@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ipFamily `ipv4` or `ipv6`.
 * @property serviceIpv4Cidr The CIDR block to assign Kubernetes pod and service IP addresses from if `ipv4` was specified when the cluster was created.
 * @property serviceIpv6Cidr The CIDR block to assign Kubernetes pod and service IP addresses from if `ipv6` was specified when the cluster was created. Kubernetes assigns service addresses from the unique local address range (fc00::/7) because you can't specify a custom IPv6 CIDR block when you create the cluster.
 */
public data class GetClusterKubernetesNetworkConfig(
    public val ipFamily: String,
    public val serviceIpv4Cidr: String,
    public val serviceIpv6Cidr: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.GetClusterKubernetesNetworkConfig): GetClusterKubernetesNetworkConfig = GetClusterKubernetesNetworkConfig(
            ipFamily = javaType.ipFamily(),
            serviceIpv4Cidr = javaType.serviceIpv4Cidr(),
            serviceIpv6Cidr = javaType.serviceIpv6Cidr(),
        )
    }
}
