@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property controlPlaneInstanceType The Amazon EC2 instance type for all Kubernetes control plane instances.
 * @property controlPlanePlacements An object representing the placement configuration for all the control plane instances of your local Amazon EKS cluster on AWS Outpost.
 * @property outpostArns List of ARNs of the Outposts hosting the EKS cluster. Only a single ARN is supported currently.
 */
public data class GetClusterOutpostConfig(
    public val controlPlaneInstanceType: String,
    public val controlPlanePlacements: List<GetClusterOutpostConfigControlPlanePlacement>,
    public val outpostArns: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.GetClusterOutpostConfig): GetClusterOutpostConfig = GetClusterOutpostConfig(
            controlPlaneInstanceType = javaType.controlPlaneInstanceType(),
            controlPlanePlacements = javaType.controlPlanePlacements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.eks.kotlin.outputs.GetClusterOutpostConfigControlPlanePlacement.Companion.toKotlin(args0)
                })
            }),
            outpostArns = javaType.outpostArns().map({ args0 -> args0 }),
        )
    }
}
