@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getCluster.
 * @property accessConfigs Configuration block for access config.
 * @property arn ARN of the cluster.
 * @property certificateAuthorities Nested attribute containing `certificate-authority-data` for your cluster.
 * @property clusterId The ID of your local Amazon EKS cluster on the AWS Outpost. This attribute isn't available for an AWS EKS cluster on AWS cloud.
 * @property createdAt Unix epoch time stamp in seconds for when the cluster was created.
 * @property enabledClusterLogTypes The enabled control plane logs.
 * @property endpoint Endpoint for your Kubernetes API server.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property identities Nested attribute containing identity provider information for your cluster. Only available on Kubernetes version 1.13 and 1.14 clusters created or upgraded on or after September 3, 2019. For an example using this information to enable IAM Roles for Service Accounts, see the `aws.eks.Cluster` resource documentation.
 * @property kubernetesNetworkConfigs Nested list containing Kubernetes Network Configuration.
 * @property name
 * @property outpostConfigs Contains Outpost Configuration.
 * @property platformVersion Platform version for the cluster.
 * @property roleArn ARN of the IAM role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
 * @property status Status of the EKS cluster. One of `CREATING`, `ACTIVE`, `DELETING`, `FAILED`.
 * @property tags Key-value map of resource tags.
 * @property upgradePolicies (Optional) Configuration block for the support policy to use for the cluster.
 * @property version Kubernetes server version for the cluster.
 * @property vpcConfig Nested list containing VPC configuration for the cluster.
 */
public data class GetClusterResult(
    public val accessConfigs: List<GetClusterAccessConfig>,
    public val arn: String,
    public val certificateAuthorities: List<GetClusterCertificateAuthority>,
    public val clusterId: String,
    public val createdAt: String,
    public val enabledClusterLogTypes: List<String>,
    public val endpoint: String,
    public val id: String,
    public val identities: List<GetClusterIdentity>,
    public val kubernetesNetworkConfigs: List<GetClusterKubernetesNetworkConfig>,
    public val name: String,
    public val outpostConfigs: List<GetClusterOutpostConfig>,
    public val platformVersion: String,
    public val roleArn: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val upgradePolicies: List<GetClusterUpgradePolicy>,
    public val version: String,
    public val vpcConfig: GetClusterVpcConfig,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.GetClusterResult): GetClusterResult =
            GetClusterResult(
                accessConfigs = javaType.accessConfigs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.eks.kotlin.outputs.GetClusterAccessConfig.Companion.toKotlin(args0)
                    })
                }),
                arn = javaType.arn(),
                certificateAuthorities = javaType.certificateAuthorities().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.eks.kotlin.outputs.GetClusterCertificateAuthority.Companion.toKotlin(args0)
                    })
                }),
                clusterId = javaType.clusterId(),
                createdAt = javaType.createdAt(),
                enabledClusterLogTypes = javaType.enabledClusterLogTypes().map({ args0 -> args0 }),
                endpoint = javaType.endpoint(),
                id = javaType.id(),
                identities = javaType.identities().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.eks.kotlin.outputs.GetClusterIdentity.Companion.toKotlin(args0)
                    })
                }),
                kubernetesNetworkConfigs = javaType.kubernetesNetworkConfigs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.eks.kotlin.outputs.GetClusterKubernetesNetworkConfig.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name(),
                outpostConfigs = javaType.outpostConfigs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.eks.kotlin.outputs.GetClusterOutpostConfig.Companion.toKotlin(args0)
                    })
                }),
                platformVersion = javaType.platformVersion(),
                roleArn = javaType.roleArn(),
                status = javaType.status(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                upgradePolicies = javaType.upgradePolicies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.eks.kotlin.outputs.GetClusterUpgradePolicy.Companion.toKotlin(args0)
                    })
                }),
                version = javaType.version(),
                vpcConfig = javaType.vpcConfig().let({ args0 ->
                    com.pulumi.aws.eks.kotlin.outputs.GetClusterVpcConfig.Companion.toKotlin(args0)
                }),
            )
    }
}
