@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the launch template.
 * @property name Name of the AutoScaling Group.
 * @property version Kubernetes version.
 */
public data class GetNodeGroupLaunchTemplate(
    public val id: String,
    public val name: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.GetNodeGroupLaunchTemplate): GetNodeGroupLaunchTemplate = GetNodeGroupLaunchTemplate(
            id = javaType.id(),
            name = javaType.name(),
            version = javaType.version(),
        )
    }
}
