@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property autoscalingGroups List of objects containing information about AutoScaling Groups.
 * @property remoteAccessSecurityGroupId Identifier of the remote access EC2 Security Group.
 */
public data class GetNodeGroupResource(
    public val autoscalingGroups: List<GetNodeGroupResourceAutoscalingGroup>,
    public val remoteAccessSecurityGroupId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.GetNodeGroupResource): GetNodeGroupResource = GetNodeGroupResource(
            autoscalingGroups = javaType.autoscalingGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.eks.kotlin.outputs.GetNodeGroupResourceAutoscalingGroup.Companion.toKotlin(args0)
                })
            }),
            remoteAccessSecurityGroupId = javaType.remoteAccessSecurityGroupId(),
        )
    }
}
