@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ec2SshKey EC2 Key Pair name that provides access for remote communication with the worker nodes in the EKS Node Group. If you specify this configuration, but do not specify `source_security_group_ids` when you create an EKS Node Group, either port 3389 for Windows, or port 22 for all other operating systems is opened on the worker nodes to the Internet (0.0.0.0/0). For Windows nodes, this will allow you to use RDP, for all others this allows you to SSH into the worker nodes.
 * @property sourceSecurityGroupIds Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
 */
public data class NodeGroupRemoteAccess(
    public val ec2SshKey: String? = null,
    public val sourceSecurityGroupIds: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.NodeGroupRemoteAccess): NodeGroupRemoteAccess = NodeGroupRemoteAccess(
            ec2SshKey = javaType.ec2SshKey().map({ args0 -> args0 }).orElse(null),
            sourceSecurityGroupIds = javaType.sourceSecurityGroupIds().map({ args0 -> args0 }),
        )
    }
}
