@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.aws.elasticache.ElasticacheFunctions.getClusterPlain
import com.pulumi.aws.elasticache.ElasticacheFunctions.getReplicationGroupPlain
import com.pulumi.aws.elasticache.ElasticacheFunctions.getSubnetGroupPlain
import com.pulumi.aws.elasticache.ElasticacheFunctions.getUserPlain
import com.pulumi.aws.elasticache.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.aws.elasticache.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.aws.elasticache.kotlin.inputs.GetReplicationGroupPlainArgs
import com.pulumi.aws.elasticache.kotlin.inputs.GetReplicationGroupPlainArgsBuilder
import com.pulumi.aws.elasticache.kotlin.inputs.GetSubnetGroupPlainArgs
import com.pulumi.aws.elasticache.kotlin.inputs.GetSubnetGroupPlainArgsBuilder
import com.pulumi.aws.elasticache.kotlin.inputs.GetUserAuthenticationMode
import com.pulumi.aws.elasticache.kotlin.inputs.GetUserPlainArgs
import com.pulumi.aws.elasticache.kotlin.inputs.GetUserPlainArgsBuilder
import com.pulumi.aws.elasticache.kotlin.outputs.GetClusterResult
import com.pulumi.aws.elasticache.kotlin.outputs.GetReplicationGroupResult
import com.pulumi.aws.elasticache.kotlin.outputs.GetSubnetGroupResult
import com.pulumi.aws.elasticache.kotlin.outputs.GetUserResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.elasticache.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.aws.elasticache.kotlin.outputs.GetReplicationGroupResult.Companion.toKotlin as getReplicationGroupResultToKotlin
import com.pulumi.aws.elasticache.kotlin.outputs.GetSubnetGroupResult.Companion.toKotlin as getSubnetGroupResultToKotlin
import com.pulumi.aws.elasticache.kotlin.outputs.GetUserResult.Companion.toKotlin as getUserResultToKotlin

public object ElasticacheFunctions {
    /**
     * Use this data source to get information about an ElastiCache Cluster
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const myCluster = aws.elasticache.getCluster({
     *     clusterId: "my-cluster-id",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * my_cluster = aws.elasticache.get_cluster(cluster_id="my-cluster-id")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var myCluster = Aws.ElastiCache.GetCluster.Invoke(new()
     *     {
     *         ClusterId = "my-cluster-id",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticache"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := elasticache.LookupCluster(ctx, &elasticache.LookupClusterArgs{
     * 			ClusterId: "my-cluster-id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.elasticache.ElasticacheFunctions;
     * import com.pulumi.aws.elasticache.inputs.GetClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var myCluster = ElasticacheFunctions.getCluster(GetClusterArgs.builder()
     *             .clusterId("my-cluster-id")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   myCluster:
     *     fn::invoke:
     *       Function: aws:elasticache:getCluster
     *       Arguments:
     *         clusterId: my-cluster-id
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCluster.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterId Group identifier.
     * @param tags Tags assigned to the resource
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(clusterId: String, tags: Map<String, String>? = null): GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterId = clusterId,
            tags = tags,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;elasticache&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit): GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about an ElastiCache Replication Group.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const bar = aws.elasticache.getReplicationGroup({
     *     replicationGroupId: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * bar = aws.elasticache.get_replication_group(replication_group_id="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var bar = Aws.ElastiCache.GetReplicationGroup.Invoke(new()
     *     {
     *         ReplicationGroupId = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticache"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := elasticache.LookupReplicationGroup(ctx, &elasticache.LookupReplicationGroupArgs{
     * 			ReplicationGroupId: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.elasticache.ElasticacheFunctions;
     * import com.pulumi.aws.elasticache.inputs.GetReplicationGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var bar = ElasticacheFunctions.getReplicationGroup(GetReplicationGroupArgs.builder()
     *             .replicationGroupId("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   bar:
     *     fn::invoke:
     *       Function: aws:elasticache:getReplicationGroup
     *       Arguments:
     *         replicationGroupId: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getReplicationGroup.
     * @return A collection of values returned by getReplicationGroup.
     */
    public suspend fun getReplicationGroup(argument: GetReplicationGroupPlainArgs): GetReplicationGroupResult =
        getReplicationGroupResultToKotlin(getReplicationGroupPlain(argument.toJava()).await())

    /**
     * @see [getReplicationGroup].
     * @param replicationGroupId Identifier for the replication group.
     * @return A collection of values returned by getReplicationGroup.
     */
    public suspend fun getReplicationGroup(replicationGroupId: String): GetReplicationGroupResult {
        val argument = GetReplicationGroupPlainArgs(
            replicationGroupId = replicationGroupId,
        )
        return getReplicationGroupResultToKotlin(getReplicationGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;elasticache&#46;kotlin&#46;inputs&#46;GetReplicationGroupPlainArgs].
     * @return A collection of values returned by getReplicationGroup.
     */
    public suspend fun getReplicationGroup(argument: suspend GetReplicationGroupPlainArgsBuilder.() -> Unit): GetReplicationGroupResult {
        val builder = GetReplicationGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationGroupResultToKotlin(getReplicationGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about a ElastiCache Subnet Group.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.elasticache.getSubnetGroup({
     *     name: "my-subnet-group",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.elasticache.get_subnet_group(name="my-subnet-group")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.ElastiCache.GetSubnetGroup.Invoke(new()
     *     {
     *         Name = "my-subnet-group",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticache"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := elasticache.LookupSubnetGroup(ctx, &elasticache.LookupSubnetGroupArgs{
     * 			Name: "my-subnet-group",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.elasticache.ElasticacheFunctions;
     * import com.pulumi.aws.elasticache.inputs.GetSubnetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ElasticacheFunctions.getSubnetGroup(GetSubnetGroupArgs.builder()
     *             .name("my-subnet-group")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:elasticache:getSubnetGroup
     *       Arguments:
     *         name: my-subnet-group
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSubnetGroup.
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(argument: GetSubnetGroupPlainArgs): GetSubnetGroupResult =
        getSubnetGroupResultToKotlin(getSubnetGroupPlain(argument.toJava()).await())

    /**
     * @see [getSubnetGroup].
     * @param name Name of the subnet group.
     * @param tags Map of tags assigned to the subnet group.
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(name: String, tags: Map<String, String>? = null): GetSubnetGroupResult {
        val argument = GetSubnetGroupPlainArgs(
            name = name,
            tags = tags,
        )
        return getSubnetGroupResultToKotlin(getSubnetGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubnetGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;elasticache&#46;kotlin&#46;inputs&#46;GetSubnetGroupPlainArgs].
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(argument: suspend GetSubnetGroupPlainArgsBuilder.() -> Unit): GetSubnetGroupResult {
        val builder = GetSubnetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubnetGroupResultToKotlin(getSubnetGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about an ElastiCache User.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const bar = aws.elasticache.getUser({
     *     userId: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * bar = aws.elasticache.get_user(user_id="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var bar = Aws.ElastiCache.GetUser.Invoke(new()
     *     {
     *         UserId = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticache"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := elasticache.LookupUser(ctx, &elasticache.LookupUserArgs{
     * 			UserId: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.elasticache.ElasticacheFunctions;
     * import com.pulumi.aws.elasticache.inputs.GetUserArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var bar = ElasticacheFunctions.getUser(GetUserArgs.builder()
     *             .userId("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   bar:
     *     fn::invoke:
     *       Function: aws:elasticache:getUser
     *       Arguments:
     *         userId: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUser.
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: GetUserPlainArgs): GetUserResult =
        getUserResultToKotlin(getUserPlain(argument.toJava()).await())

    /**
     * @see [getUser].
     * @param accessString String for what access a user possesses within the associated ElastiCache replication groups or clusters.
     * @param authenticationModes
     * @param engine
     * @param noPasswordRequired
     * @param passwords
     * @param userId Identifier for the user.
     * @param userName User name of the user.
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(
        accessString: String? = null,
        authenticationModes: List<GetUserAuthenticationMode>? = null,
        engine: String? = null,
        noPasswordRequired: Boolean? = null,
        passwords: List<String>? = null,
        userId: String,
        userName: String? = null,
    ): GetUserResult {
        val argument = GetUserPlainArgs(
            accessString = accessString,
            authenticationModes = authenticationModes,
            engine = engine,
            noPasswordRequired = noPasswordRequired,
            passwords = passwords,
            userId = userId,
            userName = userName,
        )
        return getUserResultToKotlin(getUserPlain(argument.toJava()).await())
    }

    /**
     * @see [getUser].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;elasticache&#46;kotlin&#46;inputs&#46;GetUserPlainArgs].
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: suspend GetUserPlainArgsBuilder.() -> Unit): GetUserResult {
        val builder = GetUserPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserResultToKotlin(getUserPlain(builtArgument.toJava()).await())
    }
}
