@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.aws.elasticache.ParameterGroupArgs.builder
import com.pulumi.aws.elasticache.kotlin.inputs.ParameterGroupParameterArgs
import com.pulumi.aws.elasticache.kotlin.inputs.ParameterGroupParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ElastiCache parameter group resource.
 * > **NOTE:** Attempting to remove the `reserved-memory` parameter when `family` is set to `redis2.6` or `redis2.8` may show a perpetual difference in this provider due to an ElastiCache API limitation. Leave that parameter configured with any value to workaround the issue.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.elasticache.ParameterGroup("default", {
 *     name: "cache-params",
 *     family: "redis2.8",
 *     parameters: [
 *         {
 *             name: "activerehashing",
 *             value: "yes",
 *         },
 *         {
 *             name: "min-slaves-to-write",
 *             value: "2",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.elasticache.ParameterGroup("default",
 *     name="cache-params",
 *     family="redis2.8",
 *     parameters=[
 *         {
 *             "name": "activerehashing",
 *             "value": "yes",
 *         },
 *         {
 *             "name": "min-slaves-to-write",
 *             "value": "2",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.ElastiCache.ParameterGroup("default", new()
 *     {
 *         Name = "cache-params",
 *         Family = "redis2.8",
 *         Parameters = new[]
 *         {
 *             new Aws.ElastiCache.Inputs.ParameterGroupParameterArgs
 *             {
 *                 Name = "activerehashing",
 *                 Value = "yes",
 *             },
 *             new Aws.ElastiCache.Inputs.ParameterGroupParameterArgs
 *             {
 *                 Name = "min-slaves-to-write",
 *                 Value = "2",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticache"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticache.NewParameterGroup(ctx, "default", &elasticache.ParameterGroupArgs{
 * 			Name:   pulumi.String("cache-params"),
 * 			Family: pulumi.String("redis2.8"),
 * 			Parameters: elasticache.ParameterGroupParameterArray{
 * 				&elasticache.ParameterGroupParameterArgs{
 * 					Name:  pulumi.String("activerehashing"),
 * 					Value: pulumi.String("yes"),
 * 				},
 * 				&elasticache.ParameterGroupParameterArgs{
 * 					Name:  pulumi.String("min-slaves-to-write"),
 * 					Value: pulumi.String("2"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ParameterGroup;
 * import com.pulumi.aws.elasticache.ParameterGroupArgs;
 * import com.pulumi.aws.elasticache.inputs.ParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new ParameterGroup("default", ParameterGroupArgs.builder()
 *             .name("cache-params")
 *             .family("redis2.8")
 *             .parameters(
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("activerehashing")
 *                     .value("yes")
 *                     .build(),
 *                 ParameterGroupParameterArgs.builder()
 *                     .name("min-slaves-to-write")
 *                     .value("2")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:elasticache:ParameterGroup
 *     properties:
 *       name: cache-params
 *       family: redis2.8
 *       parameters:
 *         - name: activerehashing
 *           value: yes
 *         - name: min-slaves-to-write
 *           value: '2'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ElastiCache Parameter Groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:elasticache/parameterGroup:ParameterGroup default redis-params
 * ```
 * @property description The description of the ElastiCache parameter group. Defaults to "Managed by Pulumi".
 * @property family The family of the ElastiCache parameter group.
 * @property name The name of the ElastiCache parameter.
 * @property parameters A list of ElastiCache parameters to apply.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
 */
public data class ParameterGroupArgs(
    public val description: Output<String>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<List<ParameterGroupParameterArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticache.ParameterGroupArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.ParameterGroupArgs =
        com.pulumi.aws.elasticache.ParameterGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ParameterGroupArgs].
 */
@PulumiTagMarker
public class ParameterGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<List<ParameterGroupParameterArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the ElastiCache parameter group. Defaults to "Managed by Pulumi".
     */
    @JvmName("cufpvodemiwfymxs")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The family of the ElastiCache parameter group.
     */
    @JvmName("cmsqarllplujihkw")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The name of the ElastiCache parameter.
     */
    @JvmName("dubqmkaxgitfamlv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of ElastiCache parameters to apply.
     */
    @JvmName("vrorglxptnfkglfh")
    public suspend fun parameters(`value`: Output<List<ParameterGroupParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("giamxuggcgyxlrgx")
    public suspend fun parameters(vararg values: Output<ParameterGroupParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values A list of ElastiCache parameters to apply.
     */
    @JvmName("ynepxxkvcfmynqee")
    public suspend fun parameters(values: List<Output<ParameterGroupParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("rnngtfvfstoijadh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the ElastiCache parameter group. Defaults to "Managed by Pulumi".
     */
    @JvmName("qgploxekgwskuwcl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The family of the ElastiCache parameter group.
     */
    @JvmName("uhhnvfippmyevkoh")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The name of the ElastiCache parameter.
     */
    @JvmName("kqjpbdewltogvboa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A list of ElastiCache parameters to apply.
     */
    @JvmName("brxtsikuscgokydb")
    public suspend fun parameters(`value`: List<ParameterGroupParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument A list of ElastiCache parameters to apply.
     */
    @JvmName("noajdxxcgfmkrjtw")
    public suspend fun parameters(argument: List<suspend ParameterGroupParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ParameterGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument A list of ElastiCache parameters to apply.
     */
    @JvmName("fsxjxcwworrftfkc")
    public suspend fun parameters(vararg argument: suspend ParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ParameterGroupParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument A list of ElastiCache parameters to apply.
     */
    @JvmName("spgisvnjfkkeihpr")
    public suspend fun parameters(argument: suspend ParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ParameterGroupParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values A list of ElastiCache parameters to apply.
     */
    @JvmName("crbardjijganwejb")
    public suspend fun parameters(vararg values: ParameterGroupParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("ytnswfscjhmmuiuq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("qvyaiahiswdumxdg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ParameterGroupArgs = ParameterGroupArgs(
        description = description,
        family = family,
        name = name,
        parameters = parameters,
        tags = tags,
    )
}
