@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.aws.elasticache.kotlin.outputs.ServerlessCacheCacheUsageLimits
import com.pulumi.aws.elasticache.kotlin.outputs.ServerlessCacheEndpoint
import com.pulumi.aws.elasticache.kotlin.outputs.ServerlessCacheReaderEndpoint
import com.pulumi.aws.elasticache.kotlin.outputs.ServerlessCacheTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.elasticache.kotlin.outputs.ServerlessCacheCacheUsageLimits.Companion.toKotlin as serverlessCacheCacheUsageLimitsToKotlin
import com.pulumi.aws.elasticache.kotlin.outputs.ServerlessCacheEndpoint.Companion.toKotlin as serverlessCacheEndpointToKotlin
import com.pulumi.aws.elasticache.kotlin.outputs.ServerlessCacheReaderEndpoint.Companion.toKotlin as serverlessCacheReaderEndpointToKotlin
import com.pulumi.aws.elasticache.kotlin.outputs.ServerlessCacheTimeouts.Companion.toKotlin as serverlessCacheTimeoutsToKotlin

/**
 * Builder for [ServerlessCache].
 */
@PulumiTagMarker
public class ServerlessCacheResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerlessCacheArgs = ServerlessCacheArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerlessCacheArgsBuilder.() -> Unit) {
        val builder = ServerlessCacheArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServerlessCache {
        val builtJavaResource = com.pulumi.aws.elasticache.ServerlessCache(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServerlessCache(builtJavaResource)
    }
}

/**
 * Provides an ElastiCache Serverless Cache resource which manages memcached or redis.
 * ## Example Usage
 * ### Memcached Serverless
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.elasticache.ServerlessCache("example", {
 *     engine: "memcached",
 *     name: "example",
 *     cacheUsageLimits: {
 *         dataStorage: {
 *             maximum: 10,
 *             unit: "GB",
 *         },
 *         ecpuPerSeconds: [{
 *             maximum: 5000,
 *         }],
 *     },
 *     description: "Test Server",
 *     kmsKeyId: test.arn,
 *     majorEngineVersion: "1.6",
 *     securityGroupIds: [testAwsSecurityGroup&#46;id],
 *     subnetIds: testAwsSubnet.map(__item => __item.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.elasticache.ServerlessCache("example",
 *     engine="memcached",
 *     name="example",
 *     cache_usage_limits={
 *         "data_storage": {
 *             "maximum": 10,
 *             "unit": "GB",
 *         },
 *         "ecpu_per_seconds": [{
 *             "maximum": 5000,
 *         }],
 *     },
 *     description="Test Server",
 *     kms_key_id=test["arn"],
 *     major_engine_version="1.6",
 *     security_group_ids=[test_aws_security_group["id"]],
 *     subnet_ids=[__item["id"] for __item in test_aws_subnet])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ElastiCache.ServerlessCache("example", new()
 *     {
 *         Engine = "memcached",
 *         Name = "example",
 *         CacheUsageLimits = new Aws.ElastiCache.Inputs.ServerlessCacheCacheUsageLimitsArgs
 *         {
 *             DataStorage = new Aws.ElastiCache.Inputs.ServerlessCacheCacheUsageLimitsDataStorageArgs
 *             {
 *                 Maximum = 10,
 *                 Unit = "GB",
 *             },
 *             EcpuPerSeconds = new[]
 *             {
 *                 new Aws.ElastiCache.Inputs.ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs
 *                 {
 *                     Maximum = 5000,
 *                 },
 *             },
 *         },
 *         Description = "Test Server",
 *         KmsKeyId = test.Arn,
 *         MajorEngineVersion = "1.6",
 *         SecurityGroupIds = new[]
 *         {
 *             testAwsSecurityGroup.Id,
 *         },
 *         SubnetIds = testAwsSubnet.Select(__item => __item.Id).ToList(),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticache"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range testAwsSubnet {
 * splat0 = append(splat0, val0.Id)
 * }
 * _, err := elasticache.NewServerlessCache(ctx, "example", &elasticache.ServerlessCacheArgs{
 * Engine: pulumi.String("memcached"),
 * Name: pulumi.String("example"),
 * CacheUsageLimits: &elasticache.ServerlessCacheCacheUsageLimitsArgs{
 * DataStorage: &elasticache.ServerlessCacheCacheUsageLimitsDataStorageArgs{
 * Maximum: pulumi.Int(10),
 * Unit: pulumi.String("GB"),
 * },
 * EcpuPerSeconds: elasticache.ServerlessCacheCacheUsageLimitsEcpuPerSecondArray{
 * &elasticache.ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs{
 * Maximum: pulumi.Int(5000),
 * },
 * },
 * },
 * Description: pulumi.String("Test Server"),
 * KmsKeyId: pulumi.Any(test.Arn),
 * MajorEngineVersion: pulumi.String("1.6"),
 * SecurityGroupIds: pulumi.StringArray{
 * testAwsSecurityGroup.Id,
 * },
 * SubnetIds: toPulumiArray(splat0),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ServerlessCache;
 * import com.pulumi.aws.elasticache.ServerlessCacheArgs;
 * import com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsArgs;
 * import com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsDataStorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessCache("example", ServerlessCacheArgs.builder()
 *             .engine("memcached")
 *             .name("example")
 *             .cacheUsageLimits(ServerlessCacheCacheUsageLimitsArgs.builder()
 *                 .dataStorage(ServerlessCacheCacheUsageLimitsDataStorageArgs.builder()
 *                     .maximum(10)
 *                     .unit("GB")
 *                     .build())
 *                 .ecpuPerSeconds(ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs.builder()
 *                     .maximum(5000)
 *                     .build())
 *                 .build())
 *             .description("Test Server")
 *             .kmsKeyId(test.arn())
 *             .majorEngineVersion("1.6")
 *             .securityGroupIds(testAwsSecurityGroup.id())
 *             .subnetIds(testAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Redis Serverless
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.elasticache.ServerlessCache("example", {
 *     engine: "redis",
 *     name: "example",
 *     cacheUsageLimits: {
 *         dataStorage: {
 *             maximum: 10,
 *             unit: "GB",
 *         },
 *         ecpuPerSeconds: [{
 *             maximum: 5000,
 *         }],
 *     },
 *     dailySnapshotTime: "09:00",
 *     description: "Test Server",
 *     kmsKeyId: test.arn,
 *     majorEngineVersion: "7",
 *     snapshotRetentionLimit: 1,
 *     securityGroupIds: [testAwsSecurityGroup&#46;id],
 *     subnetIds: testAwsSubnet.map(__item => __item.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.elasticache.ServerlessCache("example",
 *     engine="redis",
 *     name="example",
 *     cache_usage_limits={
 *         "data_storage": {
 *             "maximum": 10,
 *             "unit": "GB",
 *         },
 *         "ecpu_per_seconds": [{
 *             "maximum": 5000,
 *         }],
 *     },
 *     daily_snapshot_time="09:00",
 *     description="Test Server",
 *     kms_key_id=test["arn"],
 *     major_engine_version="7",
 *     snapshot_retention_limit=1,
 *     security_group_ids=[test_aws_security_group["id"]],
 *     subnet_ids=[__item["id"] for __item in test_aws_subnet])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ElastiCache.ServerlessCache("example", new()
 *     {
 *         Engine = "redis",
 *         Name = "example",
 *         CacheUsageLimits = new Aws.ElastiCache.Inputs.ServerlessCacheCacheUsageLimitsArgs
 *         {
 *             DataStorage = new Aws.ElastiCache.Inputs.ServerlessCacheCacheUsageLimitsDataStorageArgs
 *             {
 *                 Maximum = 10,
 *                 Unit = "GB",
 *             },
 *             EcpuPerSeconds = new[]
 *             {
 *                 new Aws.ElastiCache.Inputs.ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs
 *                 {
 *                     Maximum = 5000,
 *                 },
 *             },
 *         },
 *         DailySnapshotTime = "09:00",
 *         Description = "Test Server",
 *         KmsKeyId = test.Arn,
 *         MajorEngineVersion = "7",
 *         SnapshotRetentionLimit = 1,
 *         SecurityGroupIds = new[]
 *         {
 *             testAwsSecurityGroup.Id,
 *         },
 *         SubnetIds = testAwsSubnet.Select(__item => __item.Id).ToList(),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticache"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range testAwsSubnet {
 * splat0 = append(splat0, val0.Id)
 * }
 * _, err := elasticache.NewServerlessCache(ctx, "example", &elasticache.ServerlessCacheArgs{
 * Engine: pulumi.String("redis"),
 * Name: pulumi.String("example"),
 * CacheUsageLimits: &elasticache.ServerlessCacheCacheUsageLimitsArgs{
 * DataStorage: &elasticache.ServerlessCacheCacheUsageLimitsDataStorageArgs{
 * Maximum: pulumi.Int(10),
 * Unit: pulumi.String("GB"),
 * },
 * EcpuPerSeconds: elasticache.ServerlessCacheCacheUsageLimitsEcpuPerSecondArray{
 * &elasticache.ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs{
 * Maximum: pulumi.Int(5000),
 * },
 * },
 * },
 * DailySnapshotTime: pulumi.String("09:00"),
 * Description: pulumi.String("Test Server"),
 * KmsKeyId: pulumi.Any(test.Arn),
 * MajorEngineVersion: pulumi.String("7"),
 * SnapshotRetentionLimit: pulumi.Int(1),
 * SecurityGroupIds: pulumi.StringArray{
 * testAwsSecurityGroup.Id,
 * },
 * SubnetIds: toPulumiArray(splat0),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ServerlessCache;
 * import com.pulumi.aws.elasticache.ServerlessCacheArgs;
 * import com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsArgs;
 * import com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsDataStorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessCache("example", ServerlessCacheArgs.builder()
 *             .engine("redis")
 *             .name("example")
 *             .cacheUsageLimits(ServerlessCacheCacheUsageLimitsArgs.builder()
 *                 .dataStorage(ServerlessCacheCacheUsageLimitsDataStorageArgs.builder()
 *                     .maximum(10)
 *                     .unit("GB")
 *                     .build())
 *                 .ecpuPerSeconds(ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs.builder()
 *                     .maximum(5000)
 *                     .build())
 *                 .build())
 *             .dailySnapshotTime("09:00")
 *             .description("Test Server")
 *             .kmsKeyId(test.arn())
 *             .majorEngineVersion("7")
 *             .snapshotRetentionLimit(1)
 *             .securityGroupIds(testAwsSecurityGroup.id())
 *             .subnetIds(testAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ElastiCache Serverless Cache using the `name`. For example:
 * ```sh
 * $ pulumi import aws:elasticache/serverlessCache:ServerlessCache my_cluster my_cluster
 * ```
 */
public class ServerlessCache internal constructor(
    override val javaResource: com.pulumi.aws.elasticache.ServerlessCache,
) : KotlinCustomResource(javaResource, ServerlessCacheMapper) {
    /**
     * The Amazon Resource Name (ARN) of the serverless cache.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Sets the cache usage limits for storage and ElastiCache Processing Units for the cache. See configuration below.
     */
    public val cacheUsageLimits: Output<ServerlessCacheCacheUsageLimits>?
        get() = javaResource.cacheUsageLimits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serverlessCacheCacheUsageLimitsToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Timestamp of when the serverless cache was created.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The daily time that snapshots will be created from the new serverless cache. Only supported for engine type `"redis"`. Defaults to `0`.
     */
    public val dailySnapshotTime: Output<String>
        get() = javaResource.dailySnapshotTime().applyValue({ args0 -> args0 })

    /**
     * User-provided description for the serverless cache. The default is NULL.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Represents the information required for client programs to connect to a cache node. See config below for details.
     */
    public val endpoints: Output<List<ServerlessCacheEndpoint>>
        get() = javaResource.endpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serverlessCacheEndpointToKotlin(args0)
                })
            })
        })

    /**
     * Name of the cache engine to be used for this cache cluster. Valid values are `memcached` or `redis`.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * The name and version number of the engine the serverless cache is compatible with.
     */
    public val fullEngineVersion: Output<String>
        get() = javaResource.fullEngineVersion().applyValue({ args0 -> args0 })

    /**
     * ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service key is used.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The version of the cache engine that will be used to create the serverless cache.
     * See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
     */
    public val majorEngineVersion: Output<String>
        get() = javaResource.majorEngineVersion().applyValue({ args0 -> args0 })

    /**
     * The Cluster name which serves as a unique identifier to the serverless cache
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Represents the information required for client programs to connect to a cache node. See config below for details.
     */
    public val readerEndpoints: Output<List<ServerlessCacheReaderEndpoint>>
        get() = javaResource.readerEndpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serverlessCacheReaderEndpointToKotlin(args0) })
            })
        })

    /**
     * A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The list of ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis only.
     */
    public val snapshotArnsToRestores: Output<List<String>>?
        get() = javaResource.snapshotArnsToRestores().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The number of snapshots that will be retained for the serverless cache that is being created. As new snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for Redis only.
     */
    public val snapshotRetentionLimit: Output<Int>
        get() = javaResource.snapshotRetentionLimit().applyValue({ args0 -> args0 })

    /**
     * The current status of the serverless cache. The allowed values are CREATING, AVAILABLE, DELETING, CREATE-FAILED and MODIFYING.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<ServerlessCacheTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serverlessCacheTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The identifier of the UserGroup to be associated with the serverless cache. Available for Redis only. Default is NULL.
     */
    public val userGroupId: Output<String>?
        get() = javaResource.userGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ServerlessCacheMapper : ResourceMapper<ServerlessCache> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elasticache.ServerlessCache::class == javaResource::class

    override fun map(javaResource: Resource): ServerlessCache = ServerlessCache(
        javaResource as
            com.pulumi.aws.elasticache.ServerlessCache,
    )
}

/**
 * @see [ServerlessCache].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerlessCache].
 */
public suspend fun serverlessCache(
    name: String,
    block: suspend ServerlessCacheResourceBuilder.() -> Unit,
): ServerlessCache {
    val builder = ServerlessCacheResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerlessCache].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverlessCache(name: String): ServerlessCache {
    val builder = ServerlessCacheResourceBuilder()
    builder.name(name)
    return builder.build()
}
