@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.aws.elasticache.ServerlessCacheArgs.builder
import com.pulumi.aws.elasticache.kotlin.inputs.ServerlessCacheCacheUsageLimitsArgs
import com.pulumi.aws.elasticache.kotlin.inputs.ServerlessCacheCacheUsageLimitsArgsBuilder
import com.pulumi.aws.elasticache.kotlin.inputs.ServerlessCacheTimeoutsArgs
import com.pulumi.aws.elasticache.kotlin.inputs.ServerlessCacheTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ElastiCache Serverless Cache resource which manages memcached or redis.
 * ## Example Usage
 * ### Memcached Serverless
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.elasticache.ServerlessCache("example", {
 *     engine: "memcached",
 *     name: "example",
 *     cacheUsageLimits: {
 *         dataStorage: {
 *             maximum: 10,
 *             unit: "GB",
 *         },
 *         ecpuPerSeconds: [{
 *             maximum: 5000,
 *         }],
 *     },
 *     description: "Test Server",
 *     kmsKeyId: test.arn,
 *     majorEngineVersion: "1.6",
 *     securityGroupIds: [testAwsSecurityGroup&#46;id],
 *     subnetIds: testAwsSubnet.map(__item => __item.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.elasticache.ServerlessCache("example",
 *     engine="memcached",
 *     name="example",
 *     cache_usage_limits={
 *         "data_storage": {
 *             "maximum": 10,
 *             "unit": "GB",
 *         },
 *         "ecpu_per_seconds": [{
 *             "maximum": 5000,
 *         }],
 *     },
 *     description="Test Server",
 *     kms_key_id=test["arn"],
 *     major_engine_version="1.6",
 *     security_group_ids=[test_aws_security_group["id"]],
 *     subnet_ids=[__item["id"] for __item in test_aws_subnet])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ElastiCache.ServerlessCache("example", new()
 *     {
 *         Engine = "memcached",
 *         Name = "example",
 *         CacheUsageLimits = new Aws.ElastiCache.Inputs.ServerlessCacheCacheUsageLimitsArgs
 *         {
 *             DataStorage = new Aws.ElastiCache.Inputs.ServerlessCacheCacheUsageLimitsDataStorageArgs
 *             {
 *                 Maximum = 10,
 *                 Unit = "GB",
 *             },
 *             EcpuPerSeconds = new[]
 *             {
 *                 new Aws.ElastiCache.Inputs.ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs
 *                 {
 *                     Maximum = 5000,
 *                 },
 *             },
 *         },
 *         Description = "Test Server",
 *         KmsKeyId = test.Arn,
 *         MajorEngineVersion = "1.6",
 *         SecurityGroupIds = new[]
 *         {
 *             testAwsSecurityGroup.Id,
 *         },
 *         SubnetIds = testAwsSubnet.Select(__item => __item.Id).ToList(),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticache"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range testAwsSubnet {
 * splat0 = append(splat0, val0.Id)
 * }
 * _, err := elasticache.NewServerlessCache(ctx, "example", &elasticache.ServerlessCacheArgs{
 * Engine: pulumi.String("memcached"),
 * Name: pulumi.String("example"),
 * CacheUsageLimits: &elasticache.ServerlessCacheCacheUsageLimitsArgs{
 * DataStorage: &elasticache.ServerlessCacheCacheUsageLimitsDataStorageArgs{
 * Maximum: pulumi.Int(10),
 * Unit: pulumi.String("GB"),
 * },
 * EcpuPerSeconds: elasticache.ServerlessCacheCacheUsageLimitsEcpuPerSecondArray{
 * &elasticache.ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs{
 * Maximum: pulumi.Int(5000),
 * },
 * },
 * },
 * Description: pulumi.String("Test Server"),
 * KmsKeyId: pulumi.Any(test.Arn),
 * MajorEngineVersion: pulumi.String("1.6"),
 * SecurityGroupIds: pulumi.StringArray{
 * testAwsSecurityGroup.Id,
 * },
 * SubnetIds: toPulumiArray(splat0),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ServerlessCache;
 * import com.pulumi.aws.elasticache.ServerlessCacheArgs;
 * import com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsArgs;
 * import com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsDataStorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessCache("example", ServerlessCacheArgs.builder()
 *             .engine("memcached")
 *             .name("example")
 *             .cacheUsageLimits(ServerlessCacheCacheUsageLimitsArgs.builder()
 *                 .dataStorage(ServerlessCacheCacheUsageLimitsDataStorageArgs.builder()
 *                     .maximum(10)
 *                     .unit("GB")
 *                     .build())
 *                 .ecpuPerSeconds(ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs.builder()
 *                     .maximum(5000)
 *                     .build())
 *                 .build())
 *             .description("Test Server")
 *             .kmsKeyId(test.arn())
 *             .majorEngineVersion("1.6")
 *             .securityGroupIds(testAwsSecurityGroup.id())
 *             .subnetIds(testAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Redis Serverless
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.elasticache.ServerlessCache("example", {
 *     engine: "redis",
 *     name: "example",
 *     cacheUsageLimits: {
 *         dataStorage: {
 *             maximum: 10,
 *             unit: "GB",
 *         },
 *         ecpuPerSeconds: [{
 *             maximum: 5000,
 *         }],
 *     },
 *     dailySnapshotTime: "09:00",
 *     description: "Test Server",
 *     kmsKeyId: test.arn,
 *     majorEngineVersion: "7",
 *     snapshotRetentionLimit: 1,
 *     securityGroupIds: [testAwsSecurityGroup&#46;id],
 *     subnetIds: testAwsSubnet.map(__item => __item.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.elasticache.ServerlessCache("example",
 *     engine="redis",
 *     name="example",
 *     cache_usage_limits={
 *         "data_storage": {
 *             "maximum": 10,
 *             "unit": "GB",
 *         },
 *         "ecpu_per_seconds": [{
 *             "maximum": 5000,
 *         }],
 *     },
 *     daily_snapshot_time="09:00",
 *     description="Test Server",
 *     kms_key_id=test["arn"],
 *     major_engine_version="7",
 *     snapshot_retention_limit=1,
 *     security_group_ids=[test_aws_security_group["id"]],
 *     subnet_ids=[__item["id"] for __item in test_aws_subnet])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ElastiCache.ServerlessCache("example", new()
 *     {
 *         Engine = "redis",
 *         Name = "example",
 *         CacheUsageLimits = new Aws.ElastiCache.Inputs.ServerlessCacheCacheUsageLimitsArgs
 *         {
 *             DataStorage = new Aws.ElastiCache.Inputs.ServerlessCacheCacheUsageLimitsDataStorageArgs
 *             {
 *                 Maximum = 10,
 *                 Unit = "GB",
 *             },
 *             EcpuPerSeconds = new[]
 *             {
 *                 new Aws.ElastiCache.Inputs.ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs
 *                 {
 *                     Maximum = 5000,
 *                 },
 *             },
 *         },
 *         DailySnapshotTime = "09:00",
 *         Description = "Test Server",
 *         KmsKeyId = test.Arn,
 *         MajorEngineVersion = "7",
 *         SnapshotRetentionLimit = 1,
 *         SecurityGroupIds = new[]
 *         {
 *             testAwsSecurityGroup.Id,
 *         },
 *         SubnetIds = testAwsSubnet.Select(__item => __item.Id).ToList(),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticache"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range testAwsSubnet {
 * splat0 = append(splat0, val0.Id)
 * }
 * _, err := elasticache.NewServerlessCache(ctx, "example", &elasticache.ServerlessCacheArgs{
 * Engine: pulumi.String("redis"),
 * Name: pulumi.String("example"),
 * CacheUsageLimits: &elasticache.ServerlessCacheCacheUsageLimitsArgs{
 * DataStorage: &elasticache.ServerlessCacheCacheUsageLimitsDataStorageArgs{
 * Maximum: pulumi.Int(10),
 * Unit: pulumi.String("GB"),
 * },
 * EcpuPerSeconds: elasticache.ServerlessCacheCacheUsageLimitsEcpuPerSecondArray{
 * &elasticache.ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs{
 * Maximum: pulumi.Int(5000),
 * },
 * },
 * },
 * DailySnapshotTime: pulumi.String("09:00"),
 * Description: pulumi.String("Test Server"),
 * KmsKeyId: pulumi.Any(test.Arn),
 * MajorEngineVersion: pulumi.String("7"),
 * SnapshotRetentionLimit: pulumi.Int(1),
 * SecurityGroupIds: pulumi.StringArray{
 * testAwsSecurityGroup.Id,
 * },
 * SubnetIds: toPulumiArray(splat0),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.ServerlessCache;
 * import com.pulumi.aws.elasticache.ServerlessCacheArgs;
 * import com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsArgs;
 * import com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsDataStorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServerlessCache("example", ServerlessCacheArgs.builder()
 *             .engine("redis")
 *             .name("example")
 *             .cacheUsageLimits(ServerlessCacheCacheUsageLimitsArgs.builder()
 *                 .dataStorage(ServerlessCacheCacheUsageLimitsDataStorageArgs.builder()
 *                     .maximum(10)
 *                     .unit("GB")
 *                     .build())
 *                 .ecpuPerSeconds(ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs.builder()
 *                     .maximum(5000)
 *                     .build())
 *                 .build())
 *             .dailySnapshotTime("09:00")
 *             .description("Test Server")
 *             .kmsKeyId(test.arn())
 *             .majorEngineVersion("7")
 *             .snapshotRetentionLimit(1)
 *             .securityGroupIds(testAwsSecurityGroup.id())
 *             .subnetIds(testAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ElastiCache Serverless Cache using the `name`. For example:
 * ```sh
 * $ pulumi import aws:elasticache/serverlessCache:ServerlessCache my_cluster my_cluster
 * ```
 * @property cacheUsageLimits Sets the cache usage limits for storage and ElastiCache Processing Units for the cache. See configuration below.
 * @property dailySnapshotTime The daily time that snapshots will be created from the new serverless cache. Only supported for engine type `"redis"`. Defaults to `0`.
 * @property description User-provided description for the serverless cache. The default is NULL.
 * @property engine Name of the cache engine to be used for this cache cluster. Valid values are `memcached` or `redis`.
 * @property kmsKeyId ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service key is used.
 * @property majorEngineVersion The version of the cache engine that will be used to create the serverless cache.
 * See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
 * @property name The Cluster name which serves as a unique identifier to the serverless cache
 * The following arguments are optional:
 * @property securityGroupIds A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
 * @property snapshotArnsToRestores The list of ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis only.
 * @property snapshotRetentionLimit The number of snapshots that will be retained for the serverless cache that is being created. As new snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for Redis only.
 * @property subnetIds A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 * @property userGroupId The identifier of the UserGroup to be associated with the serverless cache. Available for Redis only. Default is NULL.
 */
public data class ServerlessCacheArgs(
    public val cacheUsageLimits: Output<ServerlessCacheCacheUsageLimitsArgs>? = null,
    public val dailySnapshotTime: Output<String>? = null,
    public val description: Output<String>? = null,
    public val engine: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val majorEngineVersion: Output<String>? = null,
    public val name: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val snapshotArnsToRestores: Output<List<String>>? = null,
    public val snapshotRetentionLimit: Output<Int>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<ServerlessCacheTimeoutsArgs>? = null,
    public val userGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticache.ServerlessCacheArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.ServerlessCacheArgs =
        com.pulumi.aws.elasticache.ServerlessCacheArgs.builder()
            .cacheUsageLimits(cacheUsageLimits?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dailySnapshotTime(dailySnapshotTime?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .engine(engine?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .majorEngineVersion(majorEngineVersion?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .snapshotArnsToRestores(
                snapshotArnsToRestores?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .snapshotRetentionLimit(snapshotRetentionLimit?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userGroupId(userGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessCacheArgs].
 */
@PulumiTagMarker
public class ServerlessCacheArgsBuilder internal constructor() {
    private var cacheUsageLimits: Output<ServerlessCacheCacheUsageLimitsArgs>? = null

    private var dailySnapshotTime: Output<String>? = null

    private var description: Output<String>? = null

    private var engine: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var majorEngineVersion: Output<String>? = null

    private var name: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var snapshotArnsToRestores: Output<List<String>>? = null

    private var snapshotRetentionLimit: Output<Int>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<ServerlessCacheTimeoutsArgs>? = null

    private var userGroupId: Output<String>? = null

    /**
     * @param value Sets the cache usage limits for storage and ElastiCache Processing Units for the cache. See configuration below.
     */
    @JvmName("olbcfoqvkuehydkt")
    public suspend fun cacheUsageLimits(`value`: Output<ServerlessCacheCacheUsageLimitsArgs>) {
        this.cacheUsageLimits = value
    }

    /**
     * @param value The daily time that snapshots will be created from the new serverless cache. Only supported for engine type `"redis"`. Defaults to `0`.
     */
    @JvmName("bnegnbdwbbjtmnkm")
    public suspend fun dailySnapshotTime(`value`: Output<String>) {
        this.dailySnapshotTime = value
    }

    /**
     * @param value User-provided description for the serverless cache. The default is NULL.
     */
    @JvmName("ojrwmjaefxjhtnsy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the cache engine to be used for this cache cluster. Valid values are `memcached` or `redis`.
     */
    @JvmName("flbxaaraqveynkcs")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service key is used.
     */
    @JvmName("safjuyxnlshnejdr")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The version of the cache engine that will be used to create the serverless cache.
     * See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
     */
    @JvmName("gexwauqkeripspkj")
    public suspend fun majorEngineVersion(`value`: Output<String>) {
        this.majorEngineVersion = value
    }

    /**
     * @param value The Cluster name which serves as a unique identifier to the serverless cache
     * The following arguments are optional:
     */
    @JvmName("iblfqfhvvywsygtp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
     */
    @JvmName("asdekchsgwskjqql")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("lwbuybvfktokpprm")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
     */
    @JvmName("rcsavuebfqomxeks")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The list of ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis only.
     */
    @JvmName("bvnyukdrkmuhbcot")
    public suspend fun snapshotArnsToRestores(`value`: Output<List<String>>) {
        this.snapshotArnsToRestores = value
    }

    @JvmName("priargbvuujmkkpv")
    public suspend fun snapshotArnsToRestores(vararg values: Output<String>) {
        this.snapshotArnsToRestores = Output.all(values.asList())
    }

    /**
     * @param values The list of ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis only.
     */
    @JvmName("glwprirmkyugpqmt")
    public suspend fun snapshotArnsToRestores(values: List<Output<String>>) {
        this.snapshotArnsToRestores = Output.all(values)
    }

    /**
     * @param value The number of snapshots that will be retained for the serverless cache that is being created. As new snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for Redis only.
     */
    @JvmName("jhhndyudvvrlpcwi")
    public suspend fun snapshotRetentionLimit(`value`: Output<Int>) {
        this.snapshotRetentionLimit = value
    }

    /**
     * @param value A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.
     */
    @JvmName("vsmbxewnloamhjwl")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("bxoiswluerhyhmho")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.
     */
    @JvmName("alqvsinshxyaxurn")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qahgjggquxtldsxw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("umevvalcqpqghfbl")
    public suspend fun timeouts(`value`: Output<ServerlessCacheTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The identifier of the UserGroup to be associated with the serverless cache. Available for Redis only. Default is NULL.
     */
    @JvmName("oxjjseqomyryajte")
    public suspend fun userGroupId(`value`: Output<String>) {
        this.userGroupId = value
    }

    /**
     * @param value Sets the cache usage limits for storage and ElastiCache Processing Units for the cache. See configuration below.
     */
    @JvmName("rfcxjchekhhlahst")
    public suspend fun cacheUsageLimits(`value`: ServerlessCacheCacheUsageLimitsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheUsageLimits = mapped
    }

    /**
     * @param argument Sets the cache usage limits for storage and ElastiCache Processing Units for the cache. See configuration below.
     */
    @JvmName("oxyvjvaqiheoocjj")
    public suspend fun cacheUsageLimits(argument: suspend ServerlessCacheCacheUsageLimitsArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessCacheCacheUsageLimitsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cacheUsageLimits = mapped
    }

    /**
     * @param value The daily time that snapshots will be created from the new serverless cache. Only supported for engine type `"redis"`. Defaults to `0`.
     */
    @JvmName("ahntsrwxwauxdgpr")
    public suspend fun dailySnapshotTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailySnapshotTime = mapped
    }

    /**
     * @param value User-provided description for the serverless cache. The default is NULL.
     */
    @JvmName("urihnpgguxaomvhe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the cache engine to be used for this cache cluster. Valid values are `memcached` or `redis`.
     */
    @JvmName("ulaxbwruilchxktg")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service key is used.
     */
    @JvmName("dcihiserookcevua")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The version of the cache engine that will be used to create the serverless cache.
     * See [Describe Cache Engine Versions](https://docs.aws.amazon.com/cli/latest/reference/elasticache/describe-cache-engine-versions.html) in the AWS Documentation for supported versions.
     */
    @JvmName("ptbdojbiylundumk")
    public suspend fun majorEngineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.majorEngineVersion = mapped
    }

    /**
     * @param value The Cluster name which serves as a unique identifier to the serverless cache
     * The following arguments are optional:
     */
    @JvmName("cqktjcvmxqjejmtv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
     */
    @JvmName("dntgijwcuprxmoqg")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.
     */
    @JvmName("jixuhcqekyvfcksd")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The list of ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis only.
     */
    @JvmName("fubncbtktfmtxioj")
    public suspend fun snapshotArnsToRestores(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotArnsToRestores = mapped
    }

    /**
     * @param values The list of ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis only.
     */
    @JvmName("wjlatpsveyhlwvxf")
    public suspend fun snapshotArnsToRestores(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snapshotArnsToRestores = mapped
    }

    /**
     * @param value The number of snapshots that will be retained for the serverless cache that is being created. As new snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for Redis only.
     */
    @JvmName("dlhwucyqbiljoarn")
    public suspend fun snapshotRetentionLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotRetentionLimit = mapped
    }

    /**
     * @param value A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.
     */
    @JvmName("frjiewdnwkmifuqs")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.
     */
    @JvmName("ywydfiirflolmuyc")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wwutourydqhuiepp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xcybsrkwewdiirsr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("luaagjkvjvaxgdou")
    public suspend fun timeouts(`value`: ServerlessCacheTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("etqbcdxwtxensqld")
    public suspend fun timeouts(argument: suspend ServerlessCacheTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessCacheTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value The identifier of the UserGroup to be associated with the serverless cache. Available for Redis only. Default is NULL.
     */
    @JvmName("okjkubibxjgseqpu")
    public suspend fun userGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userGroupId = mapped
    }

    internal fun build(): ServerlessCacheArgs = ServerlessCacheArgs(
        cacheUsageLimits = cacheUsageLimits,
        dailySnapshotTime = dailySnapshotTime,
        description = description,
        engine = engine,
        kmsKeyId = kmsKeyId,
        majorEngineVersion = majorEngineVersion,
        name = name,
        securityGroupIds = securityGroupIds,
        snapshotArnsToRestores = snapshotArnsToRestores,
        snapshotRetentionLimit = snapshotRetentionLimit,
        subnetIds = subnetIds,
        tags = tags,
        timeouts = timeouts,
        userGroupId = userGroupId,
    )
}
