@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [SubnetGroup].
 */
@PulumiTagMarker
public class SubnetGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubnetGroupArgs = SubnetGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubnetGroupArgsBuilder.() -> Unit) {
        val builder = SubnetGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SubnetGroup {
        val builtJavaResource = com.pulumi.aws.elasticache.SubnetGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SubnetGroup(builtJavaResource)
    }
}

/**
 * Provides an ElastiCache Subnet Group resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.ec2.Vpc("foo", {
 *     cidrBlock: "10.0.0.0/16",
 *     tags: {
 *         Name: "tf-test",
 *     },
 * });
 * const fooSubnet = new aws.ec2.Subnet("foo", {
 *     vpcId: foo.id,
 *     cidrBlock: "10.0.0.0/24",
 *     availabilityZone: "us-west-2a",
 *     tags: {
 *         Name: "tf-test",
 *     },
 * });
 * const bar = new aws.elasticache.SubnetGroup("bar", {
 *     name: "tf-test-cache-subnet",
 *     subnetIds: [fooSubnet&#46;id],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.ec2.Vpc("foo",
 *     cidr_block="10.0.0.0/16",
 *     tags={
 *         "Name": "tf-test",
 *     })
 * foo_subnet = aws.ec2.Subnet("foo",
 *     vpc_id=foo.id,
 *     cidr_block="10.0.0.0/24",
 *     availability_zone="us-west-2a",
 *     tags={
 *         "Name": "tf-test",
 *     })
 * bar = aws.elasticache.SubnetGroup("bar",
 *     name="tf-test-cache-subnet",
 *     subnet_ids=[foo_subnet&#46;id])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.Ec2.Vpc("foo", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *         Tags =
 *         {
 *             { "Name", "tf-test" },
 *         },
 *     });
 *     var fooSubnet = new Aws.Ec2.Subnet("foo", new()
 *     {
 *         VpcId = foo.Id,
 *         CidrBlock = "10.0.0.0/24",
 *         AvailabilityZone = "us-west-2a",
 *         Tags =
 *         {
 *             { "Name", "tf-test" },
 *         },
 *     });
 *     var bar = new Aws.ElastiCache.SubnetGroup("bar", new()
 *     {
 *         Name = "tf-test-cache-subnet",
 *         SubnetIds = new[]
 *         {
 *             fooSubnet.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticache"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := ec2.NewVpc(ctx, "foo", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("tf-test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		fooSubnet, err := ec2.NewSubnet(ctx, "foo", &ec2.SubnetArgs{
 * 			VpcId:            foo.ID(),
 * 			CidrBlock:        pulumi.String("10.0.0.0/24"),
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("tf-test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elasticache.NewSubnetGroup(ctx, "bar", &elasticache.SubnetGroupArgs{
 * 			Name: pulumi.String("tf-test-cache-subnet"),
 * 			SubnetIds: pulumi.StringArray{
 * 				fooSubnet.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.elasticache.SubnetGroup;
 * import com.pulumi.aws.elasticache.SubnetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Vpc("foo", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .tags(Map.of("Name", "tf-test"))
 *             .build());
 *         var fooSubnet = new Subnet("fooSubnet", SubnetArgs.builder()
 *             .vpcId(foo.id())
 *             .cidrBlock("10.0.0.0/24")
 *             .availabilityZone("us-west-2a")
 *             .tags(Map.of("Name", "tf-test"))
 *             .build());
 *         var bar = new SubnetGroup("bar", SubnetGroupArgs.builder()
 *             .name("tf-test-cache-subnet")
 *             .subnetIds(fooSubnet.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *       tags:
 *         Name: tf-test
 *   fooSubnet:
 *     type: aws:ec2:Subnet
 *     name: foo
 *     properties:
 *       vpcId: ${foo.id}
 *       cidrBlock: 10.0.0.0/24
 *       availabilityZone: us-west-2a
 *       tags:
 *         Name: tf-test
 *   bar:
 *     type: aws:elasticache:SubnetGroup
 *     properties:
 *       name: tf-test-cache-subnet
 *       subnetIds:
 *         - ${fooSubnet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ElastiCache Subnet Groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:elasticache/subnetGroup:SubnetGroup bar tf-test-cache-subnet
 * ```
 */
public class SubnetGroup internal constructor(
    override val javaResource: com.pulumi.aws.elasticache.SubnetGroup,
) : KotlinCustomResource(javaResource, SubnetGroupMapper) {
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Description for the cache subnet group. Defaults to "Managed by Pulumi".
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Name for the cache subnet group. ElastiCache converts this name to lowercase.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of VPC Subnet IDs for the cache subnet group
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object SubnetGroupMapper : ResourceMapper<SubnetGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elasticache.SubnetGroup::class == javaResource::class

    override fun map(javaResource: Resource): SubnetGroup = SubnetGroup(
        javaResource as
            com.pulumi.aws.elasticache.SubnetGroup,
    )
}

/**
 * @see [SubnetGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SubnetGroup].
 */
public suspend fun subnetGroup(name: String, block: suspend SubnetGroupResourceBuilder.() -> Unit): SubnetGroup {
    val builder = SubnetGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SubnetGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun subnetGroup(name: String): SubnetGroup {
    val builder = SubnetGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
