@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.aws.elasticache.SubnetGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ElastiCache Subnet Group resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.ec2.Vpc("foo", {
 *     cidrBlock: "10.0.0.0/16",
 *     tags: {
 *         Name: "tf-test",
 *     },
 * });
 * const fooSubnet = new aws.ec2.Subnet("foo", {
 *     vpcId: foo.id,
 *     cidrBlock: "10.0.0.0/24",
 *     availabilityZone: "us-west-2a",
 *     tags: {
 *         Name: "tf-test",
 *     },
 * });
 * const bar = new aws.elasticache.SubnetGroup("bar", {
 *     name: "tf-test-cache-subnet",
 *     subnetIds: [fooSubnet&#46;id],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.ec2.Vpc("foo",
 *     cidr_block="10.0.0.0/16",
 *     tags={
 *         "Name": "tf-test",
 *     })
 * foo_subnet = aws.ec2.Subnet("foo",
 *     vpc_id=foo.id,
 *     cidr_block="10.0.0.0/24",
 *     availability_zone="us-west-2a",
 *     tags={
 *         "Name": "tf-test",
 *     })
 * bar = aws.elasticache.SubnetGroup("bar",
 *     name="tf-test-cache-subnet",
 *     subnet_ids=[foo_subnet&#46;id])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.Ec2.Vpc("foo", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *         Tags =
 *         {
 *             { "Name", "tf-test" },
 *         },
 *     });
 *     var fooSubnet = new Aws.Ec2.Subnet("foo", new()
 *     {
 *         VpcId = foo.Id,
 *         CidrBlock = "10.0.0.0/24",
 *         AvailabilityZone = "us-west-2a",
 *         Tags =
 *         {
 *             { "Name", "tf-test" },
 *         },
 *     });
 *     var bar = new Aws.ElastiCache.SubnetGroup("bar", new()
 *     {
 *         Name = "tf-test-cache-subnet",
 *         SubnetIds = new[]
 *         {
 *             fooSubnet.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticache"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := ec2.NewVpc(ctx, "foo", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("tf-test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		fooSubnet, err := ec2.NewSubnet(ctx, "foo", &ec2.SubnetArgs{
 * 			VpcId:            foo.ID(),
 * 			CidrBlock:        pulumi.String("10.0.0.0/24"),
 * 			AvailabilityZone: pulumi.String("us-west-2a"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("tf-test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elasticache.NewSubnetGroup(ctx, "bar", &elasticache.SubnetGroupArgs{
 * 			Name: pulumi.String("tf-test-cache-subnet"),
 * 			SubnetIds: pulumi.StringArray{
 * 				fooSubnet.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.elasticache.SubnetGroup;
 * import com.pulumi.aws.elasticache.SubnetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Vpc("foo", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .tags(Map.of("Name", "tf-test"))
 *             .build());
 *         var fooSubnet = new Subnet("fooSubnet", SubnetArgs.builder()
 *             .vpcId(foo.id())
 *             .cidrBlock("10.0.0.0/24")
 *             .availabilityZone("us-west-2a")
 *             .tags(Map.of("Name", "tf-test"))
 *             .build());
 *         var bar = new SubnetGroup("bar", SubnetGroupArgs.builder()
 *             .name("tf-test-cache-subnet")
 *             .subnetIds(fooSubnet.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:ec2:Vpc
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *       tags:
 *         Name: tf-test
 *   fooSubnet:
 *     type: aws:ec2:Subnet
 *     name: foo
 *     properties:
 *       vpcId: ${foo.id}
 *       cidrBlock: 10.0.0.0/24
 *       availabilityZone: us-west-2a
 *       tags:
 *         Name: tf-test
 *   bar:
 *     type: aws:elasticache:SubnetGroup
 *     properties:
 *       name: tf-test-cache-subnet
 *       subnetIds:
 *         - ${fooSubnet.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ElastiCache Subnet Groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:elasticache/subnetGroup:SubnetGroup bar tf-test-cache-subnet
 * ```
 * @property description Description for the cache subnet group. Defaults to "Managed by Pulumi".
 * @property name Name for the cache subnet group. ElastiCache converts this name to lowercase.
 * @property subnetIds List of VPC Subnet IDs for the cache subnet group
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SubnetGroupArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticache.SubnetGroupArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.SubnetGroupArgs =
        com.pulumi.aws.elasticache.SubnetGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SubnetGroupArgs].
 */
@PulumiTagMarker
public class SubnetGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Description for the cache subnet group. Defaults to "Managed by Pulumi".
     */
    @JvmName("hlpbrwgotjmwkpjj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name for the cache subnet group. ElastiCache converts this name to lowercase.
     */
    @JvmName("wkrqwscrhirstfkd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of VPC Subnet IDs for the cache subnet group
     */
    @JvmName("ivphrehxnuxfrtna")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("jyxyetarasvijmvj")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values List of VPC Subnet IDs for the cache subnet group
     */
    @JvmName("olkhxxjtfrhavjkk")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ugrmjekmecytjool")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Description for the cache subnet group. Defaults to "Managed by Pulumi".
     */
    @JvmName("rbkrjwchwisxfpkt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name for the cache subnet group. ElastiCache converts this name to lowercase.
     */
    @JvmName("rlpudibucapqbngr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of VPC Subnet IDs for the cache subnet group
     */
    @JvmName("cncymigtsykaekii")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values List of VPC Subnet IDs for the cache subnet group
     */
    @JvmName("hjmhjgbhtjqurxak")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sjuowidebrpdbsiw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hntppydgnjbwdedh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SubnetGroupArgs = SubnetGroupArgs(
        description = description,
        name = name,
        subnetIds = subnetIds,
        tags = tags,
    )
}
