@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.aws.elasticache.UserGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an ElastiCache user group resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.elasticache.User("test", {
 *     userId: "testUserId",
 *     userName: "default",
 *     accessString: "on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember",
 *     engine: "REDIS",
 *     passwords: ["password123456789"],
 * });
 * const testUserGroup = new aws.elasticache.UserGroup("test", {
 *     engine: "REDIS",
 *     userGroupId: "userGroupId",
 *     userIds: [test&#46;userId],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.elasticache.User("test",
 *     user_id="testUserId",
 *     user_name="default",
 *     access_string="on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember",
 *     engine="REDIS",
 *     passwords=["password123456789"])
 * test_user_group = aws.elasticache.UserGroup("test",
 *     engine="REDIS",
 *     user_group_id="userGroupId",
 *     user_ids=[test&#46;user_id])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.ElastiCache.User("test", new()
 *     {
 *         UserId = "testUserId",
 *         UserName = "default",
 *         AccessString = "on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember",
 *         Engine = "REDIS",
 *         Passwords = new[]
 *         {
 *             "password123456789",
 *         },
 *     });
 *     var testUserGroup = new Aws.ElastiCache.UserGroup("test", new()
 *     {
 *         Engine = "REDIS",
 *         UserGroupId = "userGroupId",
 *         UserIds = new[]
 *         {
 *             test.UserId,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticache"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := elasticache.NewUser(ctx, "test", &elasticache.UserArgs{
 * 			UserId:       pulumi.String("testUserId"),
 * 			UserName:     pulumi.String("default"),
 * 			AccessString: pulumi.String("on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember"),
 * 			Engine:       pulumi.String("REDIS"),
 * 			Passwords: pulumi.StringArray{
 * 				pulumi.String("password123456789"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elasticache.NewUserGroup(ctx, "test", &elasticache.UserGroupArgs{
 * 			Engine:      pulumi.String("REDIS"),
 * 			UserGroupId: pulumi.String("userGroupId"),
 * 			UserIds: pulumi.StringArray{
 * 				test.UserId,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.User;
 * import com.pulumi.aws.elasticache.UserArgs;
 * import com.pulumi.aws.elasticache.UserGroup;
 * import com.pulumi.aws.elasticache.UserGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new User("test", UserArgs.builder()
 *             .userId("testUserId")
 *             .userName("default")
 *             .accessString("on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember")
 *             .engine("REDIS")
 *             .passwords("password123456789")
 *             .build());
 *         var testUserGroup = new UserGroup("testUserGroup", UserGroupArgs.builder()
 *             .engine("REDIS")
 *             .userGroupId("userGroupId")
 *             .userIds(test.userId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:elasticache:User
 *     properties:
 *       userId: testUserId
 *       userName: default
 *       accessString: on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember
 *       engine: REDIS
 *       passwords:
 *         - password123456789
 *   testUserGroup:
 *     type: aws:elasticache:UserGroup
 *     name: test
 *     properties:
 *       engine: REDIS
 *       userGroupId: userGroupId
 *       userIds:
 *         - ${test.userId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ElastiCache user groups using the `user_group_id`. For example:
 * ```sh
 * $ pulumi import aws:elasticache/userGroup:UserGroup my_user_group userGoupId1
 * ```
 * @property engine The current supported value is `REDIS`.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userGroupId The ID of the user group.
 * The following arguments are optional:
 * @property userIds The list of user IDs that belong to the user group.
 */
public data class UserGroupArgs(
    public val engine: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userGroupId: Output<String>? = null,
    public val userIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticache.UserGroupArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.UserGroupArgs =
        com.pulumi.aws.elasticache.UserGroupArgs.builder()
            .engine(engine?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userGroupId(userGroupId?.applyValue({ args0 -> args0 }))
            .userIds(userIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [UserGroupArgs].
 */
@PulumiTagMarker
public class UserGroupArgsBuilder internal constructor() {
    private var engine: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userGroupId: Output<String>? = null

    private var userIds: Output<List<String>>? = null

    /**
     * @param value The current supported value is `REDIS`.
     */
    @JvmName("qmqxhwsqquddhabw")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("soybelhohnjjmvdv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the user group.
     * The following arguments are optional:
     */
    @JvmName("fbgmjevhsvondims")
    public suspend fun userGroupId(`value`: Output<String>) {
        this.userGroupId = value
    }

    /**
     * @param value The list of user IDs that belong to the user group.
     */
    @JvmName("kdjdnanahrwcpubf")
    public suspend fun userIds(`value`: Output<List<String>>) {
        this.userIds = value
    }

    @JvmName("sauqcvytgsfiwfdx")
    public suspend fun userIds(vararg values: Output<String>) {
        this.userIds = Output.all(values.asList())
    }

    /**
     * @param values The list of user IDs that belong to the user group.
     */
    @JvmName("mbfshdwpcqnddkre")
    public suspend fun userIds(values: List<Output<String>>) {
        this.userIds = Output.all(values)
    }

    /**
     * @param value The current supported value is `REDIS`.
     */
    @JvmName("fheugddsrlvqyvmn")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vwyjrbhjclgamjja")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gklreyqbmgetyyke")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the user group.
     * The following arguments are optional:
     */
    @JvmName("kqoaogjmjqlrcfit")
    public suspend fun userGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userGroupId = mapped
    }

    /**
     * @param value The list of user IDs that belong to the user group.
     */
    @JvmName("qeqkvaejyuagktus")
    public suspend fun userIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userIds = mapped
    }

    /**
     * @param values The list of user IDs that belong to the user group.
     */
    @JvmName("hmvnpjhnguwwrrms")
    public suspend fun userIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userIds = mapped
    }

    internal fun build(): UserGroupArgs = UserGroupArgs(
        engine = engine,
        tags = tags,
        userGroupId = userGroupId,
        userIds = userIds,
    )
}
