@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin

import com.pulumi.aws.elasticache.UserGroupAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Associate an existing ElastiCache user and an existing user group.
 * > Pulumi will detect changes in the `aws.elasticache.UserGroup` since `aws.elasticache.UserGroupAssociation` changes the user IDs associated with the user group. You can ignore these changes with the `lifecycle` `ignore_changes` meta argument as shown in the example.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.elasticache.User("default", {
 *     userId: "defaultUserID",
 *     userName: "default",
 *     accessString: "on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember",
 *     engine: "REDIS",
 *     passwords: ["password123456789"],
 * });
 * const example = new aws.elasticache.UserGroup("example", {
 *     engine: "REDIS",
 *     userGroupId: "userGroupId",
 *     userIds: [_default&#46;userId],
 * });
 * const exampleUser = new aws.elasticache.User("example", {
 *     userId: "exampleUserID",
 *     userName: "exampleuser",
 *     accessString: "on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember",
 *     engine: "REDIS",
 *     passwords: ["password123456789"],
 * });
 * const exampleUserGroupAssociation = new aws.elasticache.UserGroupAssociation("example", {
 *     userGroupId: example.userGroupId,
 *     userId: exampleUser.userId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.elasticache.User("default",
 *     user_id="defaultUserID",
 *     user_name="default",
 *     access_string="on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember",
 *     engine="REDIS",
 *     passwords=["password123456789"])
 * example = aws.elasticache.UserGroup("example",
 *     engine="REDIS",
 *     user_group_id="userGroupId",
 *     user_ids=[default&#46;user_id])
 * example_user = aws.elasticache.User("example",
 *     user_id="exampleUserID",
 *     user_name="exampleuser",
 *     access_string="on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember",
 *     engine="REDIS",
 *     passwords=["password123456789"])
 * example_user_group_association = aws.elasticache.UserGroupAssociation("example",
 *     user_group_id=example.user_group_id,
 *     user_id=example_user.user_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.ElastiCache.User("default", new()
 *     {
 *         UserId = "defaultUserID",
 *         UserName = "default",
 *         AccessString = "on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember",
 *         Engine = "REDIS",
 *         Passwords = new[]
 *         {
 *             "password123456789",
 *         },
 *     });
 *     var example = new Aws.ElastiCache.UserGroup("example", new()
 *     {
 *         Engine = "REDIS",
 *         UserGroupId = "userGroupId",
 *         UserIds = new[]
 *         {
 *             @default.UserId,
 *         },
 *     });
 *     var exampleUser = new Aws.ElastiCache.User("example", new()
 *     {
 *         UserId = "exampleUserID",
 *         UserName = "exampleuser",
 *         AccessString = "on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember",
 *         Engine = "REDIS",
 *         Passwords = new[]
 *         {
 *             "password123456789",
 *         },
 *     });
 *     var exampleUserGroupAssociation = new Aws.ElastiCache.UserGroupAssociation("example", new()
 *     {
 *         UserGroupId = example.UserGroupId,
 *         UserId = exampleUser.UserId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticache"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticache.NewUser(ctx, "default", &elasticache.UserArgs{
 * 			UserId:       pulumi.String("defaultUserID"),
 * 			UserName:     pulumi.String("default"),
 * 			AccessString: pulumi.String("on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember"),
 * 			Engine:       pulumi.String("REDIS"),
 * 			Passwords: pulumi.StringArray{
 * 				pulumi.String("password123456789"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := elasticache.NewUserGroup(ctx, "example", &elasticache.UserGroupArgs{
 * 			Engine:      pulumi.String("REDIS"),
 * 			UserGroupId: pulumi.String("userGroupId"),
 * 			UserIds: pulumi.StringArray{
 * 				_default.UserId,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleUser, err := elasticache.NewUser(ctx, "example", &elasticache.UserArgs{
 * 			UserId:       pulumi.String("exampleUserID"),
 * 			UserName:     pulumi.String("exampleuser"),
 * 			AccessString: pulumi.String("on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember"),
 * 			Engine:       pulumi.String("REDIS"),
 * 			Passwords: pulumi.StringArray{
 * 				pulumi.String("password123456789"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elasticache.NewUserGroupAssociation(ctx, "example", &elasticache.UserGroupAssociationArgs{
 * 			UserGroupId: example.UserGroupId,
 * 			UserId:      exampleUser.UserId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticache.User;
 * import com.pulumi.aws.elasticache.UserArgs;
 * import com.pulumi.aws.elasticache.UserGroup;
 * import com.pulumi.aws.elasticache.UserGroupArgs;
 * import com.pulumi.aws.elasticache.UserGroupAssociation;
 * import com.pulumi.aws.elasticache.UserGroupAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new User("default", UserArgs.builder()
 *             .userId("defaultUserID")
 *             .userName("default")
 *             .accessString("on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember")
 *             .engine("REDIS")
 *             .passwords("password123456789")
 *             .build());
 *         var example = new UserGroup("example", UserGroupArgs.builder()
 *             .engine("REDIS")
 *             .userGroupId("userGroupId")
 *             .userIds(default_.userId())
 *             .build());
 *         var exampleUser = new User("exampleUser", UserArgs.builder()
 *             .userId("exampleUserID")
 *             .userName("exampleuser")
 *             .accessString("on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember")
 *             .engine("REDIS")
 *             .passwords("password123456789")
 *             .build());
 *         var exampleUserGroupAssociation = new UserGroupAssociation("exampleUserGroupAssociation", UserGroupAssociationArgs.builder()
 *             .userGroupId(example.userGroupId())
 *             .userId(exampleUser.userId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:elasticache:User
 *     properties:
 *       userId: defaultUserID
 *       userName: default
 *       accessString: on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember
 *       engine: REDIS
 *       passwords:
 *         - password123456789
 *   example:
 *     type: aws:elasticache:UserGroup
 *     properties:
 *       engine: REDIS
 *       userGroupId: userGroupId
 *       userIds:
 *         - ${default.userId}
 *   exampleUser:
 *     type: aws:elasticache:User
 *     name: example
 *     properties:
 *       userId: exampleUserID
 *       userName: exampleuser
 *       accessString: on ~app::* -@all +@read +@hash +@bitmap +@geo -setbit -bitfield -hset -hsetnx -hmset -hincrby -hincrbyfloat -hdel -bitop -geoadd -georadius -georadiusbymember
 *       engine: REDIS
 *       passwords:
 *         - password123456789
 *   exampleUserGroupAssociation:
 *     type: aws:elasticache:UserGroupAssociation
 *     name: example
 *     properties:
 *       userGroupId: ${example.userGroupId}
 *       userId: ${exampleUser.userId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import ElastiCache user group associations using the `user_group_id` and `user_id`. For example:
 * ```sh
 * $ pulumi import aws:elasticache/userGroupAssociation:UserGroupAssociation example userGoupId1,userId
 * ```
 * @property userGroupId ID of the user group.
 * @property userId ID of the user to associated with the user group.
 */
public data class UserGroupAssociationArgs(
    public val userGroupId: Output<String>? = null,
    public val userId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticache.UserGroupAssociationArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.UserGroupAssociationArgs =
        com.pulumi.aws.elasticache.UserGroupAssociationArgs.builder()
            .userGroupId(userGroupId?.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserGroupAssociationArgs].
 */
@PulumiTagMarker
public class UserGroupAssociationArgsBuilder internal constructor() {
    private var userGroupId: Output<String>? = null

    private var userId: Output<String>? = null

    /**
     * @param value ID of the user group.
     */
    @JvmName("odrnoxfkbcjnmmtj")
    public suspend fun userGroupId(`value`: Output<String>) {
        this.userGroupId = value
    }

    /**
     * @param value ID of the user to associated with the user group.
     */
    @JvmName("kidffemyyfhlhbff")
    public suspend fun userId(`value`: Output<String>) {
        this.userId = value
    }

    /**
     * @param value ID of the user group.
     */
    @JvmName("fmpcjwypjplstcix")
    public suspend fun userGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userGroupId = mapped
    }

    /**
     * @param value ID of the user to associated with the user group.
     */
    @JvmName("ykjwjdirmpwsqbhm")
    public suspend fun userId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): UserGroupAssociationArgs = UserGroupAssociationArgs(
        userGroupId = userGroupId,
        userId = userId,
    )
}
