@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.inputs

import com.pulumi.aws.elasticache.inputs.GetClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCluster.
 * @property clusterId Group identifier.
 * @property tags Tags assigned to the resource
 */
public data class GetClusterPlainArgs(
    public val clusterId: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticache.inputs.GetClusterPlainArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.inputs.GetClusterPlainArgs =
        com.pulumi.aws.elasticache.inputs.GetClusterPlainArgs.builder()
            .clusterId(clusterId.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetClusterPlainArgs].
 */
@PulumiTagMarker
public class GetClusterPlainArgsBuilder internal constructor() {
    private var clusterId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Group identifier.
     */
    @JvmName("ewiqsejkgavjfkoh")
    public suspend fun clusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterId = mapped
    }

    /**
     * @param value Tags assigned to the resource
     */
    @JvmName("afyxabvcaajhqrte")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Tags assigned to the resource
     */
    @JvmName("rfnnilogvoevoxpe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetClusterPlainArgs = GetClusterPlainArgs(
        clusterId = clusterId ?: throw PulumiNullFieldException("clusterId"),
        tags = tags,
    )
}
