@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.inputs

import com.pulumi.aws.elasticache.inputs.GetReplicationGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReplicationGroup.
 * @property replicationGroupId Identifier for the replication group.
 */
public data class GetReplicationGroupPlainArgs(
    public val replicationGroupId: String,
) : ConvertibleToJava<com.pulumi.aws.elasticache.inputs.GetReplicationGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.inputs.GetReplicationGroupPlainArgs =
        com.pulumi.aws.elasticache.inputs.GetReplicationGroupPlainArgs.builder()
            .replicationGroupId(replicationGroupId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReplicationGroupPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationGroupPlainArgsBuilder internal constructor() {
    private var replicationGroupId: String? = null

    /**
     * @param value Identifier for the replication group.
     */
    @JvmName("vtkyrokdnpvbqcft")
    public suspend fun replicationGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.replicationGroupId = mapped
    }

    internal fun build(): GetReplicationGroupPlainArgs = GetReplicationGroupPlainArgs(
        replicationGroupId = replicationGroupId ?: throw PulumiNullFieldException("replicationGroupId"),
    )
}
