@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.inputs

import com.pulumi.aws.elasticache.inputs.GetUserAuthenticationMode.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property passwordCount
 * @property type
 */
public data class GetUserAuthenticationMode(
    public val passwordCount: Int? = null,
    public val type: String? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticache.inputs.GetUserAuthenticationMode> {
    override fun toJava(): com.pulumi.aws.elasticache.inputs.GetUserAuthenticationMode =
        com.pulumi.aws.elasticache.inputs.GetUserAuthenticationMode.builder()
            .passwordCount(passwordCount?.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserAuthenticationMode].
 */
@PulumiTagMarker
public class GetUserAuthenticationModeBuilder internal constructor() {
    private var passwordCount: Int? = null

    private var type: String? = null

    /**
     * @param value
     */
    @JvmName("gnfgjbnkroxvgbjw")
    public suspend fun passwordCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.passwordCount = mapped
    }

    /**
     * @param value
     */
    @JvmName("oktstpkgdjypfpfs")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetUserAuthenticationMode = GetUserAuthenticationMode(
        passwordCount = passwordCount,
        type = type,
    )
}
