@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.inputs

import com.pulumi.aws.elasticache.inputs.GetUserPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getUser.
 * @property accessString String for what access a user possesses within the associated ElastiCache replication groups or clusters.
 * @property authenticationModes
 * @property engine
 * @property noPasswordRequired
 * @property passwords
 * @property userId Identifier for the user.
 * @property userName User name of the user.
 */
public data class GetUserPlainArgs(
    public val accessString: String? = null,
    public val authenticationModes: List<GetUserAuthenticationMode>? = null,
    public val engine: String? = null,
    public val noPasswordRequired: Boolean? = null,
    public val passwords: List<String>? = null,
    public val userId: String,
    public val userName: String? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticache.inputs.GetUserPlainArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.inputs.GetUserPlainArgs =
        com.pulumi.aws.elasticache.inputs.GetUserPlainArgs.builder()
            .accessString(accessString?.let({ args0 -> args0 }))
            .authenticationModes(
                authenticationModes?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .engine(engine?.let({ args0 -> args0 }))
            .noPasswordRequired(noPasswordRequired?.let({ args0 -> args0 }))
            .passwords(passwords?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .userId(userId.let({ args0 -> args0 }))
            .userName(userName?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUserPlainArgs].
 */
@PulumiTagMarker
public class GetUserPlainArgsBuilder internal constructor() {
    private var accessString: String? = null

    private var authenticationModes: List<GetUserAuthenticationMode>? = null

    private var engine: String? = null

    private var noPasswordRequired: Boolean? = null

    private var passwords: List<String>? = null

    private var userId: String? = null

    private var userName: String? = null

    /**
     * @param value String for what access a user possesses within the associated ElastiCache replication groups or clusters.
     */
    @JvmName("ggaggahjecatfsyc")
    public suspend fun accessString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accessString = mapped
    }

    /**
     * @param value
     */
    @JvmName("ptoqsokudoehsoty")
    public suspend fun authenticationModes(`value`: List<GetUserAuthenticationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.authenticationModes = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jahvchdkyhbepfjw")
    public suspend fun authenticationModes(argument: List<suspend GetUserAuthenticationModeBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetUserAuthenticationModeBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.authenticationModes = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jsvabqjxjfphuhtr")
    public suspend fun authenticationModes(vararg argument: suspend GetUserAuthenticationModeBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetUserAuthenticationModeBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.authenticationModes = mapped
    }

    /**
     * @param argument
     */
    @JvmName("euwrtgnnweviuyby")
    public suspend fun authenticationModes(argument: suspend GetUserAuthenticationModeBuilder.() -> Unit) {
        val toBeMapped = listOf(GetUserAuthenticationModeBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.authenticationModes = mapped
    }

    /**
     * @param values
     */
    @JvmName("ewgipppfihylbcml")
    public suspend fun authenticationModes(vararg values: GetUserAuthenticationMode) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authenticationModes = mapped
    }

    /**
     * @param value
     */
    @JvmName("pcvcjxbbdgdeubiu")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value
     */
    @JvmName("ycqdmrwpmtencutm")
    public suspend fun noPasswordRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.noPasswordRequired = mapped
    }

    /**
     * @param value
     */
    @JvmName("tpcerwevcdobjaii")
    public suspend fun passwords(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.passwords = mapped
    }

    /**
     * @param values
     */
    @JvmName("sxkhwnykitrtsiqo")
    public suspend fun passwords(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.passwords = mapped
    }

    /**
     * @param value Identifier for the user.
     */
    @JvmName("ykdtdbqxkswrsbsu")
    public suspend fun userId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.userId = mapped
    }

    /**
     * @param value User name of the user.
     */
    @JvmName("cnhvawnvvcfqwxyd")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userName = mapped
    }

    internal fun build(): GetUserPlainArgs = GetUserPlainArgs(
        accessString = accessString,
        authenticationModes = authenticationModes,
        engine = engine,
        noPasswordRequired = noPasswordRequired,
        passwords = passwords,
        userId = userId ?: throw PulumiNullFieldException("userId"),
        userName = userName,
    )
}
