@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.inputs

import com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dataStorage The maximum data storage limit in the cache, expressed in Gigabytes. See Data Storage config for more details.
 * @property ecpuPerSeconds The configuration for the number of ElastiCache Processing Units (ECPU) the cache can consume per second.See config block for more details.
 */
public data class ServerlessCacheCacheUsageLimitsArgs(
    public val dataStorage: Output<ServerlessCacheCacheUsageLimitsDataStorageArgs>? = null,
    public val ecpuPerSeconds: Output<List<ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsArgs =
        com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsArgs.builder()
            .dataStorage(dataStorage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ecpuPerSeconds(
                ecpuPerSeconds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServerlessCacheCacheUsageLimitsArgs].
 */
@PulumiTagMarker
public class ServerlessCacheCacheUsageLimitsArgsBuilder internal constructor() {
    private var dataStorage: Output<ServerlessCacheCacheUsageLimitsDataStorageArgs>? = null

    private var ecpuPerSeconds: Output<List<ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs>>? = null

    /**
     * @param value The maximum data storage limit in the cache, expressed in Gigabytes. See Data Storage config for more details.
     */
    @JvmName("hpweeegnngjjnxsf")
    public suspend fun dataStorage(`value`: Output<ServerlessCacheCacheUsageLimitsDataStorageArgs>) {
        this.dataStorage = value
    }

    /**
     * @param value The configuration for the number of ElastiCache Processing Units (ECPU) the cache can consume per second.See config block for more details.
     */
    @JvmName("idtdmafmuxnkygpl")
    public suspend fun ecpuPerSeconds(`value`: Output<List<ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs>>) {
        this.ecpuPerSeconds = value
    }

    @JvmName("rhcbnjflacuongul")
    public suspend fun ecpuPerSeconds(vararg values: Output<ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs>) {
        this.ecpuPerSeconds = Output.all(values.asList())
    }

    /**
     * @param values The configuration for the number of ElastiCache Processing Units (ECPU) the cache can consume per second.See config block for more details.
     */
    @JvmName("cerhwuxdlipiscpa")
    public suspend fun ecpuPerSeconds(values: List<Output<ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs>>) {
        this.ecpuPerSeconds = Output.all(values)
    }

    /**
     * @param value The maximum data storage limit in the cache, expressed in Gigabytes. See Data Storage config for more details.
     */
    @JvmName("shpntmssdlmegxex")
    public suspend fun dataStorage(`value`: ServerlessCacheCacheUsageLimitsDataStorageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataStorage = mapped
    }

    /**
     * @param argument The maximum data storage limit in the cache, expressed in Gigabytes. See Data Storage config for more details.
     */
    @JvmName("twmhcochdlqdkjwl")
    public suspend fun dataStorage(argument: suspend ServerlessCacheCacheUsageLimitsDataStorageArgsBuilder.() -> Unit) {
        val toBeMapped = ServerlessCacheCacheUsageLimitsDataStorageArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataStorage = mapped
    }

    /**
     * @param value The configuration for the number of ElastiCache Processing Units (ECPU) the cache can consume per second.See config block for more details.
     */
    @JvmName("aaeangyadgbkrrtx")
    public suspend fun ecpuPerSeconds(`value`: List<ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecpuPerSeconds = mapped
    }

    /**
     * @param argument The configuration for the number of ElastiCache Processing Units (ECPU) the cache can consume per second.See config block for more details.
     */
    @JvmName("mrasytqnhbjxykna")
    public suspend fun ecpuPerSeconds(argument: List<suspend ServerlessCacheCacheUsageLimitsEcpuPerSecondArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServerlessCacheCacheUsageLimitsEcpuPerSecondArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ecpuPerSeconds = mapped
    }

    /**
     * @param argument The configuration for the number of ElastiCache Processing Units (ECPU) the cache can consume per second.See config block for more details.
     */
    @JvmName("hrcdefukhvyvlvjm")
    public suspend fun ecpuPerSeconds(vararg argument: suspend ServerlessCacheCacheUsageLimitsEcpuPerSecondArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServerlessCacheCacheUsageLimitsEcpuPerSecondArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ecpuPerSeconds = mapped
    }

    /**
     * @param argument The configuration for the number of ElastiCache Processing Units (ECPU) the cache can consume per second.See config block for more details.
     */
    @JvmName("ivsycnkasbwereqx")
    public suspend fun ecpuPerSeconds(argument: suspend ServerlessCacheCacheUsageLimitsEcpuPerSecondArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServerlessCacheCacheUsageLimitsEcpuPerSecondArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ecpuPerSeconds = mapped
    }

    /**
     * @param values The configuration for the number of ElastiCache Processing Units (ECPU) the cache can consume per second.See config block for more details.
     */
    @JvmName("nmfhcbgmswiarjps")
    public suspend fun ecpuPerSeconds(vararg values: ServerlessCacheCacheUsageLimitsEcpuPerSecondArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ecpuPerSeconds = mapped
    }

    internal fun build(): ServerlessCacheCacheUsageLimitsArgs = ServerlessCacheCacheUsageLimitsArgs(
        dataStorage = dataStorage,
        ecpuPerSeconds = ecpuPerSeconds,
    )
}
