@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.inputs

import com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsDataStorageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maximum
 * @property minimum
 * @property unit The unit that the storage is measured in, in GB.
 */
public data class ServerlessCacheCacheUsageLimitsDataStorageArgs(
    public val maximum: Output<Int>? = null,
    public val minimum: Output<Int>? = null,
    public val unit: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsDataStorageArgs> {
    override fun toJava(): com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsDataStorageArgs =
        com.pulumi.aws.elasticache.inputs.ServerlessCacheCacheUsageLimitsDataStorageArgs.builder()
            .maximum(maximum?.applyValue({ args0 -> args0 }))
            .minimum(minimum?.applyValue({ args0 -> args0 }))
            .unit(unit.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerlessCacheCacheUsageLimitsDataStorageArgs].
 */
@PulumiTagMarker
public class ServerlessCacheCacheUsageLimitsDataStorageArgsBuilder internal constructor() {
    private var maximum: Output<Int>? = null

    private var minimum: Output<Int>? = null

    private var unit: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("pcbdncwnxfscraga")
    public suspend fun maximum(`value`: Output<Int>) {
        this.maximum = value
    }

    /**
     * @param value
     */
    @JvmName("xeaqonjeibunalva")
    public suspend fun minimum(`value`: Output<Int>) {
        this.minimum = value
    }

    /**
     * @param value The unit that the storage is measured in, in GB.
     */
    @JvmName("ehkvilrhmpkrrull")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value
     */
    @JvmName("uvgmbjcxmotluqkx")
    public suspend fun maximum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximum = mapped
    }

    /**
     * @param value
     */
    @JvmName("ttqidretkijlfqjr")
    public suspend fun minimum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimum = mapped
    }

    /**
     * @param value The unit that the storage is measured in, in GB.
     */
    @JvmName("bkamnbnbhvyosjnv")
    public suspend fun unit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    internal fun build(): ServerlessCacheCacheUsageLimitsDataStorageArgs =
        ServerlessCacheCacheUsageLimitsDataStorageArgs(
            maximum = maximum,
            minimum = minimum,
            unit = unit ?: throw PulumiNullFieldException("unit"),
        )
}
