@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address
 * @property availabilityZone Availability Zone for the cache cluster. If you want to create cache nodes in multi-az, use `preferred_availability_zones` instead. Default: System chosen Availability Zone. Changing this value will re-create the resource.
 * @property id
 * @property outpostArn
 * @property port The port number on which each of the cache nodes will accept connections. For Memcached the default is 11211, and for Redis the default port is 6379. Cannot be provided with `replication_group_id`. Changing this value will re-create the resource.
 */
public data class ClusterCacheNode(
    public val address: String? = null,
    public val availabilityZone: String? = null,
    public val id: String? = null,
    public val outpostArn: String? = null,
    public val port: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticache.outputs.ClusterCacheNode): ClusterCacheNode = ClusterCacheNode(
            address = javaType.address().map({ args0 -> args0 }).orElse(null),
            availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            outpostArn = javaType.outpostArn().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
        )
    }
}
