@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address
 * @property availabilityZone Availability Zone for the cache cluster.
 * @property id
 * @property outpostArn
 * @property port The port number on which each of the cache nodes will
 * accept connections.
 */
public data class GetClusterCacheNode(
    public val address: String,
    public val availabilityZone: String,
    public val id: String,
    public val outpostArn: String,
    public val port: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticache.outputs.GetClusterCacheNode): GetClusterCacheNode = GetClusterCacheNode(
            address = javaType.address(),
            availabilityZone = javaType.availabilityZone(),
            id = javaType.id(),
            outpostArn = javaType.outpostArn(),
            port = javaType.port(),
        )
    }
}
