@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dataStorage The maximum data storage limit in the cache, expressed in Gigabytes. See Data Storage config for more details.
 * @property ecpuPerSeconds The configuration for the number of ElastiCache Processing Units (ECPU) the cache can consume per second.See config block for more details.
 */
public data class ServerlessCacheCacheUsageLimits(
    public val dataStorage: ServerlessCacheCacheUsageLimitsDataStorage? = null,
    public val ecpuPerSeconds: List<ServerlessCacheCacheUsageLimitsEcpuPerSecond>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticache.outputs.ServerlessCacheCacheUsageLimits): ServerlessCacheCacheUsageLimits = ServerlessCacheCacheUsageLimits(
            dataStorage = javaType.dataStorage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.elasticache.kotlin.outputs.ServerlessCacheCacheUsageLimitsDataStorage.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ecpuPerSeconds = javaType.ecpuPerSeconds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.elasticache.kotlin.outputs.ServerlessCacheCacheUsageLimitsEcpuPerSecond.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
