@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property maximum
 * @property minimum
 * @property unit The unit that the storage is measured in, in GB.
 */
public data class ServerlessCacheCacheUsageLimitsDataStorage(
    public val maximum: Int? = null,
    public val minimum: Int? = null,
    public val unit: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticache.outputs.ServerlessCacheCacheUsageLimitsDataStorage): ServerlessCacheCacheUsageLimitsDataStorage = ServerlessCacheCacheUsageLimitsDataStorage(
            maximum = javaType.maximum().map({ args0 -> args0 }).orElse(null),
            minimum = javaType.minimum().map({ args0 -> args0 }).orElse(null),
            unit = javaType.unit(),
        )
    }
}
