@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticache.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address The DNS hostname of the cache node.
 * @property port The port number that the cache engine is listening on. Set as integer.
 */
public data class ServerlessCacheEndpoint(
    public val address: String,
    public val port: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticache.outputs.ServerlessCacheEndpoint): ServerlessCacheEndpoint = ServerlessCacheEndpoint(
            address = javaType.address(),
            port = javaType.port(),
        )
    }
}
