@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ApplicationVersion].
 */
@PulumiTagMarker
public class ApplicationVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationVersionArgs = ApplicationVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationVersionArgsBuilder.() -> Unit) {
        val builder = ApplicationVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationVersion {
        val builtJavaResource =
            com.pulumi.aws.elasticbeanstalk.ApplicationVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApplicationVersion(builtJavaResource)
    }
}

/**
 * Provides an Elastic Beanstalk Application Version Resource. Elastic Beanstalk allows
 * you to deploy and manage applications in the AWS cloud without worrying about
 * the infrastructure that runs those applications.
 * This resource creates a Beanstalk Application Version that can be deployed to a Beanstalk
 * Environment.
 * > **NOTE on Application Version Resource:**  When using the Application Version resource with multiple
 * Elastic Beanstalk Environments it is possible that an error may be returned
 * when attempting to delete an Application Version while it is still in use by a different environment.
 * To work around this you can either create each environment in a separate AWS account or create your `aws.elasticbeanstalk.ApplicationVersion` resources with a unique names in your Elastic Beanstalk Application. For example &lt;revision&gt;-&lt;environment&gt;.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.s3.BucketV2("default", {bucket: "tftest.applicationversion.bucket"});
 * const defaultBucketObjectv2 = new aws.s3.BucketObjectv2("default", {
 *     bucket: _default.id,
 *     key: "beanstalk/go-v1.zip",
 *     source: new pulumi.asset.FileAsset("go-v1.zip"),
 * });
 * const defaultApplication = new aws.elasticbeanstalk.Application("default", {
 *     name: "tf-test-name",
 *     description: "tf-test-desc",
 * });
 * const defaultApplicationVersion = new aws.elasticbeanstalk.ApplicationVersion("default", {
 *     name: "tf-test-version-label",
 *     application: "tf-test-name",
 *     description: "application version",
 *     bucket: _default.id,
 *     key: defaultBucketObjectv2.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.s3.BucketV2("default", bucket="tftest.applicationversion.bucket")
 * default_bucket_objectv2 = aws.s3.BucketObjectv2("default",
 *     bucket=default.id,
 *     key="beanstalk/go-v1.zip",
 *     source=pulumi.FileAsset("go-v1.zip"))
 * default_application = aws.elasticbeanstalk.Application("default",
 *     name="tf-test-name",
 *     description="tf-test-desc")
 * default_application_version = aws.elasticbeanstalk.ApplicationVersion("default",
 *     name="tf-test-version-label",
 *     application="tf-test-name",
 *     description="application version",
 *     bucket=default.id,
 *     key=default_bucket_objectv2.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.S3.BucketV2("default", new()
 *     {
 *         Bucket = "tftest.applicationversion.bucket",
 *     });
 *     var defaultBucketObjectv2 = new Aws.S3.BucketObjectv2("default", new()
 *     {
 *         Bucket = @default.Id,
 *         Key = "beanstalk/go-v1.zip",
 *         Source = new FileAsset("go-v1.zip"),
 *     });
 *     var defaultApplication = new Aws.ElasticBeanstalk.Application("default", new()
 *     {
 *         Name = "tf-test-name",
 *         Description = "tf-test-desc",
 *     });
 *     var defaultApplicationVersion = new Aws.ElasticBeanstalk.ApplicationVersion("default", new()
 *     {
 *         Name = "tf-test-version-label",
 *         Application = "tf-test-name",
 *         Description = "application version",
 *         Bucket = @default.Id,
 *         Key = defaultBucketObjectv2.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticbeanstalk"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := s3.NewBucketV2(ctx, "default", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("tftest.applicationversion.bucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBucketObjectv2, err := s3.NewBucketObjectv2(ctx, "default", &s3.BucketObjectv2Args{
 * 			Bucket: _default.ID(),
 * 			Key:    pulumi.String("beanstalk/go-v1.zip"),
 * 			Source: pulumi.NewFileAsset("go-v1.zip"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elasticbeanstalk.NewApplication(ctx, "default", &elasticbeanstalk.ApplicationArgs{
 * 			Name:        pulumi.String("tf-test-name"),
 * 			Description: pulumi.String("tf-test-desc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elasticbeanstalk.NewApplicationVersion(ctx, "default", &elasticbeanstalk.ApplicationVersionArgs{
 * 			Name:        pulumi.String("tf-test-version-label"),
 * 			Application: pulumi.Any("tf-test-name"),
 * 			Description: pulumi.String("application version"),
 * 			Bucket:      _default.ID(),
 * 			Key:         defaultBucketObjectv2.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.elasticbeanstalk.Application;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationArgs;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationVersion;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationVersionArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new BucketV2("default", BucketV2Args.builder()
 *             .bucket("tftest.applicationversion.bucket")
 *             .build());
 *         var defaultBucketObjectv2 = new BucketObjectv2("defaultBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(default_.id())
 *             .key("beanstalk/go-v1.zip")
 *             .source(new FileAsset("go-v1.zip"))
 *             .build());
 *         var defaultApplication = new Application("defaultApplication", ApplicationArgs.builder()
 *             .name("tf-test-name")
 *             .description("tf-test-desc")
 *             .build());
 *         var defaultApplicationVersion = new ApplicationVersion("defaultApplicationVersion", ApplicationVersionArgs.builder()
 *             .name("tf-test-version-label")
 *             .application("tf-test-name")
 *             .description("application version")
 *             .bucket(default_.id())
 *             .key(defaultBucketObjectv2.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: tftest.applicationversion.bucket
 *   defaultBucketObjectv2:
 *     type: aws:s3:BucketObjectv2
 *     name: default
 *     properties:
 *       bucket: ${default.id}
 *       key: beanstalk/go-v1.zip
 *       source:
 *         fn::FileAsset: go-v1.zip
 *   defaultApplication:
 *     type: aws:elasticbeanstalk:Application
 *     name: default
 *     properties:
 *       name: tf-test-name
 *       description: tf-test-desc
 *   defaultApplicationVersion:
 *     type: aws:elasticbeanstalk:ApplicationVersion
 *     name: default
 *     properties:
 *       name: tf-test-version-label
 *       application: tf-test-name
 *       description: application version
 *       bucket: ${default.id}
 *       key: ${defaultBucketObjectv2.id}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class ApplicationVersion internal constructor(
    override val javaResource: com.pulumi.aws.elasticbeanstalk.ApplicationVersion,
) : KotlinCustomResource(javaResource, ApplicationVersionMapper) {
    /**
     * Name of the Beanstalk Application the version is associated with.
     */
    public val application: Output<String>
        get() = javaResource.application().applyValue({ args0 -> args0 })

    /**
     * ARN assigned by AWS for this Elastic Beanstalk Application.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * S3 bucket that contains the Application Version source bundle.
     */
    public val bucket: Output<String>
        get() = javaResource.bucket().applyValue({ args0 -> args0 })

    /**
     * Short description of the Application Version.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * On delete, force an Application Version to be deleted when it may be in use by multiple Elastic Beanstalk Environments.
     */
    public val forceDelete: Output<Boolean>?
        get() = javaResource.forceDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * S3 object that is the Application Version source bundle.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * Unique name for the this Application Version.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value map of tags for the Elastic Beanstalk Application Version. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ApplicationVersionMapper : ResourceMapper<ApplicationVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elasticbeanstalk.ApplicationVersion::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationVersion = ApplicationVersion(
        javaResource as
            com.pulumi.aws.elasticbeanstalk.ApplicationVersion,
    )
}

/**
 * @see [ApplicationVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationVersion].
 */
public suspend fun applicationVersion(
    name: String,
    block: suspend ApplicationVersionResourceBuilder.() -> Unit,
): ApplicationVersion {
    val builder = ApplicationVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationVersion(name: String): ApplicationVersion {
    val builder = ApplicationVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
