@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin

import com.pulumi.aws.elasticbeanstalk.ApplicationVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Beanstalk Application Version Resource. Elastic Beanstalk allows
 * you to deploy and manage applications in the AWS cloud without worrying about
 * the infrastructure that runs those applications.
 * This resource creates a Beanstalk Application Version that can be deployed to a Beanstalk
 * Environment.
 * > **NOTE on Application Version Resource:**  When using the Application Version resource with multiple
 * Elastic Beanstalk Environments it is possible that an error may be returned
 * when attempting to delete an Application Version while it is still in use by a different environment.
 * To work around this you can either create each environment in a separate AWS account or create your `aws.elasticbeanstalk.ApplicationVersion` resources with a unique names in your Elastic Beanstalk Application. For example &lt;revision&gt;-&lt;environment&gt;.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.s3.BucketV2("default", {bucket: "tftest.applicationversion.bucket"});
 * const defaultBucketObjectv2 = new aws.s3.BucketObjectv2("default", {
 *     bucket: _default.id,
 *     key: "beanstalk/go-v1.zip",
 *     source: new pulumi.asset.FileAsset("go-v1.zip"),
 * });
 * const defaultApplication = new aws.elasticbeanstalk.Application("default", {
 *     name: "tf-test-name",
 *     description: "tf-test-desc",
 * });
 * const defaultApplicationVersion = new aws.elasticbeanstalk.ApplicationVersion("default", {
 *     name: "tf-test-version-label",
 *     application: "tf-test-name",
 *     description: "application version",
 *     bucket: _default.id,
 *     key: defaultBucketObjectv2.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.s3.BucketV2("default", bucket="tftest.applicationversion.bucket")
 * default_bucket_objectv2 = aws.s3.BucketObjectv2("default",
 *     bucket=default.id,
 *     key="beanstalk/go-v1.zip",
 *     source=pulumi.FileAsset("go-v1.zip"))
 * default_application = aws.elasticbeanstalk.Application("default",
 *     name="tf-test-name",
 *     description="tf-test-desc")
 * default_application_version = aws.elasticbeanstalk.ApplicationVersion("default",
 *     name="tf-test-version-label",
 *     application="tf-test-name",
 *     description="application version",
 *     bucket=default.id,
 *     key=default_bucket_objectv2.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.S3.BucketV2("default", new()
 *     {
 *         Bucket = "tftest.applicationversion.bucket",
 *     });
 *     var defaultBucketObjectv2 = new Aws.S3.BucketObjectv2("default", new()
 *     {
 *         Bucket = @default.Id,
 *         Key = "beanstalk/go-v1.zip",
 *         Source = new FileAsset("go-v1.zip"),
 *     });
 *     var defaultApplication = new Aws.ElasticBeanstalk.Application("default", new()
 *     {
 *         Name = "tf-test-name",
 *         Description = "tf-test-desc",
 *     });
 *     var defaultApplicationVersion = new Aws.ElasticBeanstalk.ApplicationVersion("default", new()
 *     {
 *         Name = "tf-test-version-label",
 *         Application = "tf-test-name",
 *         Description = "application version",
 *         Bucket = @default.Id,
 *         Key = defaultBucketObjectv2.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticbeanstalk"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := s3.NewBucketV2(ctx, "default", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("tftest.applicationversion.bucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultBucketObjectv2, err := s3.NewBucketObjectv2(ctx, "default", &s3.BucketObjectv2Args{
 * 			Bucket: _default.ID(),
 * 			Key:    pulumi.String("beanstalk/go-v1.zip"),
 * 			Source: pulumi.NewFileAsset("go-v1.zip"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elasticbeanstalk.NewApplication(ctx, "default", &elasticbeanstalk.ApplicationArgs{
 * 			Name:        pulumi.String("tf-test-name"),
 * 			Description: pulumi.String("tf-test-desc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elasticbeanstalk.NewApplicationVersion(ctx, "default", &elasticbeanstalk.ApplicationVersionArgs{
 * 			Name:        pulumi.String("tf-test-version-label"),
 * 			Application: pulumi.Any("tf-test-name"),
 * 			Description: pulumi.String("application version"),
 * 			Bucket:      _default.ID(),
 * 			Key:         defaultBucketObjectv2.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.elasticbeanstalk.Application;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationArgs;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationVersion;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationVersionArgs;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new BucketV2("default", BucketV2Args.builder()
 *             .bucket("tftest.applicationversion.bucket")
 *             .build());
 *         var defaultBucketObjectv2 = new BucketObjectv2("defaultBucketObjectv2", BucketObjectv2Args.builder()
 *             .bucket(default_.id())
 *             .key("beanstalk/go-v1.zip")
 *             .source(new FileAsset("go-v1.zip"))
 *             .build());
 *         var defaultApplication = new Application("defaultApplication", ApplicationArgs.builder()
 *             .name("tf-test-name")
 *             .description("tf-test-desc")
 *             .build());
 *         var defaultApplicationVersion = new ApplicationVersion("defaultApplicationVersion", ApplicationVersionArgs.builder()
 *             .name("tf-test-version-label")
 *             .application("tf-test-name")
 *             .description("application version")
 *             .bucket(default_.id())
 *             .key(defaultBucketObjectv2.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: tftest.applicationversion.bucket
 *   defaultBucketObjectv2:
 *     type: aws:s3:BucketObjectv2
 *     name: default
 *     properties:
 *       bucket: ${default.id}
 *       key: beanstalk/go-v1.zip
 *       source:
 *         fn::FileAsset: go-v1.zip
 *   defaultApplication:
 *     type: aws:elasticbeanstalk:Application
 *     name: default
 *     properties:
 *       name: tf-test-name
 *       description: tf-test-desc
 *   defaultApplicationVersion:
 *     type: aws:elasticbeanstalk:ApplicationVersion
 *     name: default
 *     properties:
 *       name: tf-test-version-label
 *       application: tf-test-name
 *       description: application version
 *       bucket: ${default.id}
 *       key: ${defaultBucketObjectv2.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property application Name of the Beanstalk Application the version is associated with.
 * @property bucket S3 bucket that contains the Application Version source bundle.
 * @property description Short description of the Application Version.
 * @property forceDelete On delete, force an Application Version to be deleted when it may be in use by multiple Elastic Beanstalk Environments.
 * @property key S3 object that is the Application Version source bundle.
 * @property name Unique name for the this Application Version.
 * The following arguments are optional:
 * @property tags Key-value map of tags for the Elastic Beanstalk Application Version. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ApplicationVersionArgs(
    public val application: Output<String>? = null,
    public val bucket: Output<String>? = null,
    public val description: Output<String>? = null,
    public val forceDelete: Output<Boolean>? = null,
    public val key: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticbeanstalk.ApplicationVersionArgs> {
    override fun toJava(): com.pulumi.aws.elasticbeanstalk.ApplicationVersionArgs =
        com.pulumi.aws.elasticbeanstalk.ApplicationVersionArgs.builder()
            .application(application?.applyValue({ args0 -> args0 }))
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .forceDelete(forceDelete?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationVersionArgs].
 */
@PulumiTagMarker
public class ApplicationVersionArgsBuilder internal constructor() {
    private var application: Output<String>? = null

    private var bucket: Output<String>? = null

    private var description: Output<String>? = null

    private var forceDelete: Output<Boolean>? = null

    private var key: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the Beanstalk Application the version is associated with.
     */
    @JvmName("llpxlsmnyuwtojuf")
    public suspend fun application(`value`: Output<String>) {
        this.application = value
    }

    /**
     * @param value S3 bucket that contains the Application Version source bundle.
     */
    @JvmName("qaqehdyrckaqpcij")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Short description of the Application Version.
     */
    @JvmName("kdcjjkeqoqsslsro")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value On delete, force an Application Version to be deleted when it may be in use by multiple Elastic Beanstalk Environments.
     */
    @JvmName("velsgrhtomvcvgso")
    public suspend fun forceDelete(`value`: Output<Boolean>) {
        this.forceDelete = value
    }

    /**
     * @param value S3 object that is the Application Version source bundle.
     */
    @JvmName("hilfemfidyksylss")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Unique name for the this Application Version.
     * The following arguments are optional:
     */
    @JvmName("krkodesawyxoinro")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of tags for the Elastic Beanstalk Application Version. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lwcfiegfhlrtgqsc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the Beanstalk Application the version is associated with.
     */
    @JvmName("qawocdnlcdrdedum")
    public suspend fun application(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.application = mapped
    }

    /**
     * @param value S3 bucket that contains the Application Version source bundle.
     */
    @JvmName("ocmxuirtqtmqmxac")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Short description of the Application Version.
     */
    @JvmName("sutfacqyimdahutr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value On delete, force an Application Version to be deleted when it may be in use by multiple Elastic Beanstalk Environments.
     */
    @JvmName("brfyttjxcxdwttdy")
    public suspend fun forceDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDelete = mapped
    }

    /**
     * @param value S3 object that is the Application Version source bundle.
     */
    @JvmName("sjkpbklkanqsmaui")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Unique name for the this Application Version.
     * The following arguments are optional:
     */
    @JvmName("vvnhetssccfpxokw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of tags for the Elastic Beanstalk Application Version. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fvlcbeqrthreeuut")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of tags for the Elastic Beanstalk Application Version. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ltogwuedjklsteuo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ApplicationVersionArgs = ApplicationVersionArgs(
        application = application,
        bucket = bucket,
        description = description,
        forceDelete = forceDelete,
        key = key,
        name = name,
        tags = tags,
    )
}
