@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin

import com.pulumi.aws.elasticbeanstalk.kotlin.outputs.ConfigurationTemplateSetting
import com.pulumi.aws.elasticbeanstalk.kotlin.outputs.ConfigurationTemplateSetting.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ConfigurationTemplate].
 */
@PulumiTagMarker
public class ConfigurationTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConfigurationTemplateArgs = ConfigurationTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConfigurationTemplateArgsBuilder.() -> Unit) {
        val builder = ConfigurationTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConfigurationTemplate {
        val builtJavaResource =
            com.pulumi.aws.elasticbeanstalk.ConfigurationTemplate(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConfigurationTemplate(builtJavaResource)
    }
}

/**
 * Provides an Elastic Beanstalk Configuration Template, which are associated with
 * a specific application and are used to deploy different versions of the
 * application with the same configuration settings.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const tftest = new aws.elasticbeanstalk.Application("tftest", {
 *     name: "tf-test-name",
 *     description: "tf-test-desc",
 * });
 * const myTemplate = new aws.elasticbeanstalk.ConfigurationTemplate("my_template", {
 *     name: "tf-test-template-config",
 *     application: tftest.name,
 *     solutionStackName: "64bit Amazon Linux 2015.09 v2.0.8 running Go 1.4",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * tftest = aws.elasticbeanstalk.Application("tftest",
 *     name="tf-test-name",
 *     description="tf-test-desc")
 * my_template = aws.elasticbeanstalk.ConfigurationTemplate("my_template",
 *     name="tf-test-template-config",
 *     application=tftest.name,
 *     solution_stack_name="64bit Amazon Linux 2015.09 v2.0.8 running Go 1.4")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tftest = new Aws.ElasticBeanstalk.Application("tftest", new()
 *     {
 *         Name = "tf-test-name",
 *         Description = "tf-test-desc",
 *     });
 *     var myTemplate = new Aws.ElasticBeanstalk.ConfigurationTemplate("my_template", new()
 *     {
 *         Name = "tf-test-template-config",
 *         Application = tftest.Name,
 *         SolutionStackName = "64bit Amazon Linux 2015.09 v2.0.8 running Go 1.4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticbeanstalk"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tftest, err := elasticbeanstalk.NewApplication(ctx, "tftest", &elasticbeanstalk.ApplicationArgs{
 * 			Name:        pulumi.String("tf-test-name"),
 * 			Description: pulumi.String("tf-test-desc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elasticbeanstalk.NewConfigurationTemplate(ctx, "my_template", &elasticbeanstalk.ConfigurationTemplateArgs{
 * 			Name:              pulumi.String("tf-test-template-config"),
 * 			Application:       tftest.Name,
 * 			SolutionStackName: pulumi.String("64bit Amazon Linux 2015.09 v2.0.8 running Go 1.4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticbeanstalk.Application;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationArgs;
 * import com.pulumi.aws.elasticbeanstalk.ConfigurationTemplate;
 * import com.pulumi.aws.elasticbeanstalk.ConfigurationTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tftest = new Application("tftest", ApplicationArgs.builder()
 *             .name("tf-test-name")
 *             .description("tf-test-desc")
 *             .build());
 *         var myTemplate = new ConfigurationTemplate("myTemplate", ConfigurationTemplateArgs.builder()
 *             .name("tf-test-template-config")
 *             .application(tftest.name())
 *             .solutionStackName("64bit Amazon Linux 2015.09 v2.0.8 running Go 1.4")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   tftest:
 *     type: aws:elasticbeanstalk:Application
 *     properties:
 *       name: tf-test-name
 *       description: tf-test-desc
 *   myTemplate:
 *     type: aws:elasticbeanstalk:ConfigurationTemplate
 *     name: my_template
 *     properties:
 *       name: tf-test-template-config
 *       application: ${tftest.name}
 *       solutionStackName: 64bit Amazon Linux 2015.09 v2.0.8 running Go 1.4
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Option Settings
 * The `setting` field supports the following format:
 * * `namespace` - unique namespace identifying the option's associated AWS resource
 * * `name` - name of the configuration option
 * * `value` - value for the configuration option
 * * `resource` - (Optional) resource name for [scheduled action](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html#command-options-general-autoscalingscheduledaction)
 */
public class ConfigurationTemplate internal constructor(
    override val javaResource: com.pulumi.aws.elasticbeanstalk.ConfigurationTemplate,
) : KotlinCustomResource(javaResource, ConfigurationTemplateMapper) {
    /**
     * name of the application to associate with this configuration template
     */
    public val application: Output<String>
        get() = javaResource.application().applyValue({ args0 -> args0 })

    /**
     * Short description of the Template
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the environment used with this configuration template
     */
    public val environmentId: Output<String>?
        get() = javaResource.environmentId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique name for this Template.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    public val settings: Output<List<ConfigurationTemplateSetting>>
        get() = javaResource.settings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * A solution stack to base your Template
     * off of. Example stacks can be found in the [Amazon API documentation][1]
     */
    public val solutionStackName: Output<String>?
        get() = javaResource.solutionStackName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ConfigurationTemplateMapper : ResourceMapper<ConfigurationTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elasticbeanstalk.ConfigurationTemplate::class == javaResource::class

    override fun map(javaResource: Resource): ConfigurationTemplate =
        ConfigurationTemplate(javaResource as com.pulumi.aws.elasticbeanstalk.ConfigurationTemplate)
}

/**
 * @see [ConfigurationTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConfigurationTemplate].
 */
public suspend fun configurationTemplate(
    name: String,
    block: suspend ConfigurationTemplateResourceBuilder.() -> Unit,
): ConfigurationTemplate {
    val builder = ConfigurationTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConfigurationTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun configurationTemplate(name: String): ConfigurationTemplate {
    val builder = ConfigurationTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
