@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin

import com.pulumi.aws.elasticbeanstalk.ConfigurationTemplateArgs.builder
import com.pulumi.aws.elasticbeanstalk.kotlin.inputs.ConfigurationTemplateSettingArgs
import com.pulumi.aws.elasticbeanstalk.kotlin.inputs.ConfigurationTemplateSettingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an Elastic Beanstalk Configuration Template, which are associated with
 * a specific application and are used to deploy different versions of the
 * application with the same configuration settings.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const tftest = new aws.elasticbeanstalk.Application("tftest", {
 *     name: "tf-test-name",
 *     description: "tf-test-desc",
 * });
 * const myTemplate = new aws.elasticbeanstalk.ConfigurationTemplate("my_template", {
 *     name: "tf-test-template-config",
 *     application: tftest.name,
 *     solutionStackName: "64bit Amazon Linux 2015.09 v2.0.8 running Go 1.4",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * tftest = aws.elasticbeanstalk.Application("tftest",
 *     name="tf-test-name",
 *     description="tf-test-desc")
 * my_template = aws.elasticbeanstalk.ConfigurationTemplate("my_template",
 *     name="tf-test-template-config",
 *     application=tftest.name,
 *     solution_stack_name="64bit Amazon Linux 2015.09 v2.0.8 running Go 1.4")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tftest = new Aws.ElasticBeanstalk.Application("tftest", new()
 *     {
 *         Name = "tf-test-name",
 *         Description = "tf-test-desc",
 *     });
 *     var myTemplate = new Aws.ElasticBeanstalk.ConfigurationTemplate("my_template", new()
 *     {
 *         Name = "tf-test-template-config",
 *         Application = tftest.Name,
 *         SolutionStackName = "64bit Amazon Linux 2015.09 v2.0.8 running Go 1.4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticbeanstalk"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tftest, err := elasticbeanstalk.NewApplication(ctx, "tftest", &elasticbeanstalk.ApplicationArgs{
 * 			Name:        pulumi.String("tf-test-name"),
 * 			Description: pulumi.String("tf-test-desc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elasticbeanstalk.NewConfigurationTemplate(ctx, "my_template", &elasticbeanstalk.ConfigurationTemplateArgs{
 * 			Name:              pulumi.String("tf-test-template-config"),
 * 			Application:       tftest.Name,
 * 			SolutionStackName: pulumi.String("64bit Amazon Linux 2015.09 v2.0.8 running Go 1.4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticbeanstalk.Application;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationArgs;
 * import com.pulumi.aws.elasticbeanstalk.ConfigurationTemplate;
 * import com.pulumi.aws.elasticbeanstalk.ConfigurationTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tftest = new Application("tftest", ApplicationArgs.builder()
 *             .name("tf-test-name")
 *             .description("tf-test-desc")
 *             .build());
 *         var myTemplate = new ConfigurationTemplate("myTemplate", ConfigurationTemplateArgs.builder()
 *             .name("tf-test-template-config")
 *             .application(tftest.name())
 *             .solutionStackName("64bit Amazon Linux 2015.09 v2.0.8 running Go 1.4")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   tftest:
 *     type: aws:elasticbeanstalk:Application
 *     properties:
 *       name: tf-test-name
 *       description: tf-test-desc
 *   myTemplate:
 *     type: aws:elasticbeanstalk:ConfigurationTemplate
 *     name: my_template
 *     properties:
 *       name: tf-test-template-config
 *       application: ${tftest.name}
 *       solutionStackName: 64bit Amazon Linux 2015.09 v2.0.8 running Go 1.4
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Option Settings
 * The `setting` field supports the following format:
 * * `namespace` - unique namespace identifying the option's associated AWS resource
 * * `name` - name of the configuration option
 * * `value` - value for the configuration option
 * * `resource` - (Optional) resource name for [scheduled action](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html#command-options-general-autoscalingscheduledaction)
 * @property application name of the application to associate with this configuration template
 * @property description Short description of the Template
 * @property environmentId The ID of the environment used with this configuration template
 * @property name A unique name for this Template.
 * @property settings Option settings to configure the new Environment. These
 * override specific values that are set as defaults. The format is detailed
 * below in Option Settings
 * @property solutionStackName A solution stack to base your Template
 * off of. Example stacks can be found in the [Amazon API documentation][1]
 */
public data class ConfigurationTemplateArgs(
    public val application: Output<String>? = null,
    public val description: Output<String>? = null,
    public val environmentId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val settings: Output<List<ConfigurationTemplateSettingArgs>>? = null,
    public val solutionStackName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticbeanstalk.ConfigurationTemplateArgs> {
    override fun toJava(): com.pulumi.aws.elasticbeanstalk.ConfigurationTemplateArgs =
        com.pulumi.aws.elasticbeanstalk.ConfigurationTemplateArgs.builder()
            .application(application?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .settings(
                settings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .solutionStackName(solutionStackName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConfigurationTemplateArgs].
 */
@PulumiTagMarker
public class ConfigurationTemplateArgsBuilder internal constructor() {
    private var application: Output<String>? = null

    private var description: Output<String>? = null

    private var environmentId: Output<String>? = null

    private var name: Output<String>? = null

    private var settings: Output<List<ConfigurationTemplateSettingArgs>>? = null

    private var solutionStackName: Output<String>? = null

    /**
     * @param value name of the application to associate with this configuration template
     */
    @JvmName("jmrcibsuuxawewkn")
    public suspend fun application(`value`: Output<String>) {
        this.application = value
    }

    /**
     * @param value Short description of the Template
     */
    @JvmName("tcmwvrlipcjooieh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the environment used with this configuration template
     */
    @JvmName("ynuywwgjhcrtmxcc")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value A unique name for this Template.
     */
    @JvmName("ydqqlixrqjctneav")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    @JvmName("vbgsbvnlsharevxq")
    public suspend fun settings(`value`: Output<List<ConfigurationTemplateSettingArgs>>) {
        this.settings = value
    }

    @JvmName("sqegmnojxcjmjroh")
    public suspend fun settings(vararg values: Output<ConfigurationTemplateSettingArgs>) {
        this.settings = Output.all(values.asList())
    }

    /**
     * @param values Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    @JvmName("xlyimtpcfdaxtfus")
    public suspend fun settings(values: List<Output<ConfigurationTemplateSettingArgs>>) {
        this.settings = Output.all(values)
    }

    /**
     * @param value A solution stack to base your Template
     * off of. Example stacks can be found in the [Amazon API documentation][1]
     */
    @JvmName("tdgyrqbhwnuirkdq")
    public suspend fun solutionStackName(`value`: Output<String>) {
        this.solutionStackName = value
    }

    /**
     * @param value name of the application to associate with this configuration template
     */
    @JvmName("rpqcvbuterorwxpj")
    public suspend fun application(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.application = mapped
    }

    /**
     * @param value Short description of the Template
     */
    @JvmName("bogjrttvxooublge")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the environment used with this configuration template
     */
    @JvmName("ipxvgkbbfwxufwyr")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value A unique name for this Template.
     */
    @JvmName("ejkyobtdxuqitevu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    @JvmName("innakmvqvkivukgb")
    public suspend fun settings(`value`: List<ConfigurationTemplateSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    @JvmName("rnjgkokcoiratjfs")
    public suspend fun settings(argument: List<suspend ConfigurationTemplateSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConfigurationTemplateSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param argument Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    @JvmName("kodkudplibrocrus")
    public suspend fun settings(vararg argument: suspend ConfigurationTemplateSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ConfigurationTemplateSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param argument Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    @JvmName("jkovyajeiwouxisg")
    public suspend fun settings(argument: suspend ConfigurationTemplateSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConfigurationTemplateSettingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param values Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    @JvmName("ksfypfmrefbxthjy")
    public suspend fun settings(vararg values: ConfigurationTemplateSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value A solution stack to base your Template
     * off of. Example stacks can be found in the [Amazon API documentation][1]
     */
    @JvmName("dfbynrgtitugbjnt")
    public suspend fun solutionStackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.solutionStackName = mapped
    }

    internal fun build(): ConfigurationTemplateArgs = ConfigurationTemplateArgs(
        application = application,
        description = description,
        environmentId = environmentId,
        name = name,
        settings = settings,
        solutionStackName = solutionStackName,
    )
}
