@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin

import com.pulumi.aws.elasticbeanstalk.ElasticbeanstalkFunctions.getApplicationPlain
import com.pulumi.aws.elasticbeanstalk.ElasticbeanstalkFunctions.getHostedZonePlain
import com.pulumi.aws.elasticbeanstalk.ElasticbeanstalkFunctions.getSolutionStackPlain
import com.pulumi.aws.elasticbeanstalk.kotlin.inputs.GetApplicationPlainArgs
import com.pulumi.aws.elasticbeanstalk.kotlin.inputs.GetApplicationPlainArgsBuilder
import com.pulumi.aws.elasticbeanstalk.kotlin.inputs.GetHostedZonePlainArgs
import com.pulumi.aws.elasticbeanstalk.kotlin.inputs.GetHostedZonePlainArgsBuilder
import com.pulumi.aws.elasticbeanstalk.kotlin.inputs.GetSolutionStackPlainArgs
import com.pulumi.aws.elasticbeanstalk.kotlin.inputs.GetSolutionStackPlainArgsBuilder
import com.pulumi.aws.elasticbeanstalk.kotlin.outputs.GetApplicationResult
import com.pulumi.aws.elasticbeanstalk.kotlin.outputs.GetHostedZoneResult
import com.pulumi.aws.elasticbeanstalk.kotlin.outputs.GetSolutionStackResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.elasticbeanstalk.kotlin.outputs.GetApplicationResult.Companion.toKotlin as getApplicationResultToKotlin
import com.pulumi.aws.elasticbeanstalk.kotlin.outputs.GetHostedZoneResult.Companion.toKotlin as getHostedZoneResultToKotlin
import com.pulumi.aws.elasticbeanstalk.kotlin.outputs.GetSolutionStackResult.Companion.toKotlin as getSolutionStackResultToKotlin

public object ElasticbeanstalkFunctions {
    /**
     * Retrieve information about an Elastic Beanstalk Application.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.elasticbeanstalk.getApplication({
     *     name: "example",
     * });
     * export const arn = example.then(example => example.arn);
     * export const description = example.then(example => example.description);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.elasticbeanstalk.get_application(name="example")
     * pulumi.export("arn", example.arn)
     * pulumi.export("description", example.description)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.ElasticBeanstalk.GetApplication.Invoke(new()
     *     {
     *         Name = "example",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["arn"] = example.Apply(getApplicationResult => getApplicationResult.Arn),
     *         ["description"] = example.Apply(getApplicationResult => getApplicationResult.Description),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticbeanstalk"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := elasticbeanstalk.LookupApplication(ctx, &elasticbeanstalk.LookupApplicationArgs{
     * 			Name: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("arn", example.Arn)
     * 		ctx.Export("description", example.Description)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.elasticbeanstalk.ElasticbeanstalkFunctions;
     * import com.pulumi.aws.elasticbeanstalk.inputs.GetApplicationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = ElasticbeanstalkFunctions.getApplication(GetApplicationArgs.builder()
     *             .name("example")
     *             .build());
     *         ctx.export("arn", example.applyValue(getApplicationResult -> getApplicationResult.arn()));
     *         ctx.export("description", example.applyValue(getApplicationResult -> getApplicationResult.description()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:elasticbeanstalk:getApplication
     *       Arguments:
     *         name: example
     * outputs:
     *   arn: ${example.arn}
     *   description: ${example.description}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApplication.
     * @return A collection of values returned by getApplication.
     */
    public suspend fun getApplication(argument: GetApplicationPlainArgs): GetApplicationResult =
        getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())

    /**
     * @see [getApplication].
     * @param name Name of the application
     * @return A collection of values returned by getApplication.
     */
    public suspend fun getApplication(name: String): GetApplicationResult {
        val argument = GetApplicationPlainArgs(
            name = name,
        )
        return getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplication].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;elasticbeanstalk&#46;kotlin&#46;inputs&#46;GetApplicationPlainArgs].
     * @return A collection of values returned by getApplication.
     */
    public suspend fun getApplication(argument: suspend GetApplicationPlainArgsBuilder.() -> Unit): GetApplicationResult {
        val builder = GetApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationResultToKotlin(getApplicationPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ID of an [elastic beanstalk hosted zone](http://docs.aws.amazon.com/general/latest/gr/rande.html#elasticbeanstalk_region).
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const current = aws.elasticbeanstalk.getHostedZone({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * current = aws.elasticbeanstalk.get_hosted_zone()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var current = Aws.ElasticBeanstalk.GetHostedZone.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticbeanstalk"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := elasticbeanstalk.GetHostedZone(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.elasticbeanstalk.ElasticbeanstalkFunctions;
     * import com.pulumi.aws.elasticbeanstalk.inputs.GetHostedZoneArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var current = ElasticbeanstalkFunctions.getHostedZone();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   current:
     *     fn::invoke:
     *       Function: aws:elasticbeanstalk:getHostedZone
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getHostedZone.
     * @return A collection of values returned by getHostedZone.
     */
    public suspend fun getHostedZone(argument: GetHostedZonePlainArgs): GetHostedZoneResult =
        getHostedZoneResultToKotlin(getHostedZonePlain(argument.toJava()).await())

    /**
     * @see [getHostedZone].
     * @param region Region you'd like the zone for. By default, fetches the current region.
     * @return A collection of values returned by getHostedZone.
     */
    public suspend fun getHostedZone(region: String? = null): GetHostedZoneResult {
        val argument = GetHostedZonePlainArgs(
            region = region,
        )
        return getHostedZoneResultToKotlin(getHostedZonePlain(argument.toJava()).await())
    }

    /**
     * @see [getHostedZone].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;elasticbeanstalk&#46;kotlin&#46;inputs&#46;GetHostedZonePlainArgs].
     * @return A collection of values returned by getHostedZone.
     */
    public suspend fun getHostedZone(argument: suspend GetHostedZonePlainArgsBuilder.() -> Unit): GetHostedZoneResult {
        val builder = GetHostedZonePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHostedZoneResultToKotlin(getHostedZonePlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the name of a elastic beanstalk solution stack.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const multiDocker = aws.elasticbeanstalk.getSolutionStack({
     *     mostRecent: true,
     *     nameRegex: "^64bit Amazon Linux (.*) Multi-container Docker (.*)$",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * multi_docker = aws.elasticbeanstalk.get_solution_stack(most_recent=True,
     *     name_regex="^64bit Amazon Linux (.*) Multi-container Docker (.*)$")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var multiDocker = Aws.ElasticBeanstalk.GetSolutionStack.Invoke(new()
     *     {
     *         MostRecent = true,
     *         NameRegex = "^64bit Amazon Linux (.*) Multi-container Docker (.*)$",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticbeanstalk"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := elasticbeanstalk.GetSolutionStack(ctx, &elasticbeanstalk.GetSolutionStackArgs{
     * 			MostRecent: pulumi.BoolRef(true),
     * 			NameRegex:  "^64bit Amazon Linux (.*) Multi-container Docker (.*)$",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.elasticbeanstalk.ElasticbeanstalkFunctions;
     * import com.pulumi.aws.elasticbeanstalk.inputs.GetSolutionStackArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var multiDocker = ElasticbeanstalkFunctions.getSolutionStack(GetSolutionStackArgs.builder()
     *             .mostRecent(true)
     *             .nameRegex("^64bit Amazon Linux (.*) Multi-container Docker (.*)$")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   multiDocker:
     *     fn::invoke:
     *       Function: aws:elasticbeanstalk:getSolutionStack
     *       Arguments:
     *         mostRecent: true
     *         nameRegex: ^64bit Amazon Linux (.*) Multi-container Docker (.*)$
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSolutionStack.
     * @return A collection of values returned by getSolutionStack.
     */
    public suspend fun getSolutionStack(argument: GetSolutionStackPlainArgs): GetSolutionStackResult =
        getSolutionStackResultToKotlin(getSolutionStackPlain(argument.toJava()).await())

    /**
     * @see [getSolutionStack].
     * @param mostRecent If more than one result is returned, use the most
     * recent solution stack.
     * @param nameRegex Regex string to apply to the solution stack list returned
     * by AWS. See [Elastic Beanstalk Supported Platforms][beanstalk-platforms] from
     * AWS documentation for reference solution stack names.
     * > **NOTE:** If more or less than a single match is returned by the search,
     * this call will fail. Ensure that your search is specific enough to return
     * a single solution stack, or use `most_recent` to choose the most recent one.
     * @return A collection of values returned by getSolutionStack.
     */
    public suspend fun getSolutionStack(mostRecent: Boolean? = null, nameRegex: String): GetSolutionStackResult {
        val argument = GetSolutionStackPlainArgs(
            mostRecent = mostRecent,
            nameRegex = nameRegex,
        )
        return getSolutionStackResultToKotlin(getSolutionStackPlain(argument.toJava()).await())
    }

    /**
     * @see [getSolutionStack].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;elasticbeanstalk&#46;kotlin&#46;inputs&#46;GetSolutionStackPlainArgs].
     * @return A collection of values returned by getSolutionStack.
     */
    public suspend fun getSolutionStack(argument: suspend GetSolutionStackPlainArgsBuilder.() -> Unit): GetSolutionStackResult {
        val builder = GetSolutionStackPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSolutionStackResultToKotlin(getSolutionStackPlain(builtArgument.toJava()).await())
    }
}
