@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin

import com.pulumi.aws.elasticbeanstalk.kotlin.outputs.EnvironmentAllSetting
import com.pulumi.aws.elasticbeanstalk.kotlin.outputs.EnvironmentSetting
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.elasticbeanstalk.kotlin.outputs.EnvironmentAllSetting.Companion.toKotlin as environmentAllSettingToKotlin
import com.pulumi.aws.elasticbeanstalk.kotlin.outputs.EnvironmentSetting.Companion.toKotlin as environmentSettingToKotlin

/**
 * Builder for [Environment].
 */
@PulumiTagMarker
public class EnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EnvironmentArgs = EnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EnvironmentArgsBuilder.() -> Unit) {
        val builder = EnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Environment {
        val builtJavaResource = com.pulumi.aws.elasticbeanstalk.Environment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Environment(builtJavaResource)
    }
}

/**
 * Provides an Elastic Beanstalk Environment Resource. Elastic Beanstalk allows
 * you to deploy and manage applications in the AWS cloud without worrying about
 * the infrastructure that runs those applications.
 * Environments are often things such as `development`, `integration`, or
 * `production`.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const tftest = new aws.elasticbeanstalk.Application("tftest", {
 *     name: "tf-test-name",
 *     description: "tf-test-desc",
 * });
 * const tfenvtest = new aws.elasticbeanstalk.Environment("tfenvtest", {
 *     name: "tf-test-name",
 *     application: tftest.name,
 *     solutionStackName: "64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * tftest = aws.elasticbeanstalk.Application("tftest",
 *     name="tf-test-name",
 *     description="tf-test-desc")
 * tfenvtest = aws.elasticbeanstalk.Environment("tfenvtest",
 *     name="tf-test-name",
 *     application=tftest.name,
 *     solution_stack_name="64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tftest = new Aws.ElasticBeanstalk.Application("tftest", new()
 *     {
 *         Name = "tf-test-name",
 *         Description = "tf-test-desc",
 *     });
 *     var tfenvtest = new Aws.ElasticBeanstalk.Environment("tfenvtest", new()
 *     {
 *         Name = "tf-test-name",
 *         Application = tftest.Name,
 *         SolutionStackName = "64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticbeanstalk"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tftest, err := elasticbeanstalk.NewApplication(ctx, "tftest", &elasticbeanstalk.ApplicationArgs{
 * 			Name:        pulumi.String("tf-test-name"),
 * 			Description: pulumi.String("tf-test-desc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elasticbeanstalk.NewEnvironment(ctx, "tfenvtest", &elasticbeanstalk.EnvironmentArgs{
 * 			Name:              pulumi.String("tf-test-name"),
 * 			Application:       tftest.Name,
 * 			SolutionStackName: pulumi.String("64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticbeanstalk.Application;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationArgs;
 * import com.pulumi.aws.elasticbeanstalk.Environment;
 * import com.pulumi.aws.elasticbeanstalk.EnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tftest = new Application("tftest", ApplicationArgs.builder()
 *             .name("tf-test-name")
 *             .description("tf-test-desc")
 *             .build());
 *         var tfenvtest = new Environment("tfenvtest", EnvironmentArgs.builder()
 *             .name("tf-test-name")
 *             .application(tftest.name())
 *             .solutionStackName("64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   tftest:
 *     type: aws:elasticbeanstalk:Application
 *     properties:
 *       name: tf-test-name
 *       description: tf-test-desc
 *   tfenvtest:
 *     type: aws:elasticbeanstalk:Environment
 *     properties:
 *       name: tf-test-name
 *       application: ${tftest.name}
 *       solutionStackName: 64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Option Settings
 * Some options can be stack-specific, check [AWS Docs](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html)
 * for supported options and examples.
 * The `setting` and `all_settings` mappings support the following format:
 * * `namespace` - unique namespace identifying the option's associated AWS resource
 * * `name` - name of the configuration option
 * * `value` - value for the configuration option
 * * `resource` - (Optional) resource name for [scheduled action](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html#command-options-general-autoscalingscheduledaction)
 * ### Example With Options
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const tftest = new aws.elasticbeanstalk.Application("tftest", {
 *     name: "tf-test-name",
 *     description: "tf-test-desc",
 * });
 * const tfenvtest = new aws.elasticbeanstalk.Environment("tfenvtest", {
 *     name: "tf-test-name",
 *     application: tftest.name,
 *     solutionStackName: "64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4",
 *     settings: [
 *         {
 *             namespace: "aws:ec2:vpc",
 *             name: "VPCId",
 *             value: "vpc-xxxxxxxx",
 *         },
 *         {
 *             namespace: "aws:ec2:vpc",
 *             name: "Subnets",
 *             value: "subnet-xxxxxxxx",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * tftest = aws.elasticbeanstalk.Application("tftest",
 *     name="tf-test-name",
 *     description="tf-test-desc")
 * tfenvtest = aws.elasticbeanstalk.Environment("tfenvtest",
 *     name="tf-test-name",
 *     application=tftest.name,
 *     solution_stack_name="64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4",
 *     settings=[
 *         {
 *             "namespace": "aws:ec2:vpc",
 *             "name": "VPCId",
 *             "value": "vpc-xxxxxxxx",
 *         },
 *         {
 *             "namespace": "aws:ec2:vpc",
 *             "name": "Subnets",
 *             "value": "subnet-xxxxxxxx",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tftest = new Aws.ElasticBeanstalk.Application("tftest", new()
 *     {
 *         Name = "tf-test-name",
 *         Description = "tf-test-desc",
 *     });
 *     var tfenvtest = new Aws.ElasticBeanstalk.Environment("tfenvtest", new()
 *     {
 *         Name = "tf-test-name",
 *         Application = tftest.Name,
 *         SolutionStackName = "64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4",
 *         Settings = new[]
 *         {
 *             new Aws.ElasticBeanstalk.Inputs.EnvironmentSettingArgs
 *             {
 *                 Namespace = "aws:ec2:vpc",
 *                 Name = "VPCId",
 *                 Value = "vpc-xxxxxxxx",
 *             },
 *             new Aws.ElasticBeanstalk.Inputs.EnvironmentSettingArgs
 *             {
 *                 Namespace = "aws:ec2:vpc",
 *                 Name = "Subnets",
 *                 Value = "subnet-xxxxxxxx",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticbeanstalk"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tftest, err := elasticbeanstalk.NewApplication(ctx, "tftest", &elasticbeanstalk.ApplicationArgs{
 * 			Name:        pulumi.String("tf-test-name"),
 * 			Description: pulumi.String("tf-test-desc"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elasticbeanstalk.NewEnvironment(ctx, "tfenvtest", &elasticbeanstalk.EnvironmentArgs{
 * 			Name:              pulumi.String("tf-test-name"),
 * 			Application:       tftest.Name,
 * 			SolutionStackName: pulumi.String("64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4"),
 * 			Settings: elasticbeanstalk.EnvironmentSettingArray{
 * 				&elasticbeanstalk.EnvironmentSettingArgs{
 * 					Namespace: pulumi.String("aws:ec2:vpc"),
 * 					Name:      pulumi.String("VPCId"),
 * 					Value:     pulumi.String("vpc-xxxxxxxx"),
 * 				},
 * 				&elasticbeanstalk.EnvironmentSettingArgs{
 * 					Namespace: pulumi.String("aws:ec2:vpc"),
 * 					Name:      pulumi.String("Subnets"),
 * 					Value:     pulumi.String("subnet-xxxxxxxx"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticbeanstalk.Application;
 * import com.pulumi.aws.elasticbeanstalk.ApplicationArgs;
 * import com.pulumi.aws.elasticbeanstalk.Environment;
 * import com.pulumi.aws.elasticbeanstalk.EnvironmentArgs;
 * import com.pulumi.aws.elasticbeanstalk.inputs.EnvironmentSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tftest = new Application("tftest", ApplicationArgs.builder()
 *             .name("tf-test-name")
 *             .description("tf-test-desc")
 *             .build());
 *         var tfenvtest = new Environment("tfenvtest", EnvironmentArgs.builder()
 *             .name("tf-test-name")
 *             .application(tftest.name())
 *             .solutionStackName("64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4")
 *             .settings(
 *                 EnvironmentSettingArgs.builder()
 *                     .namespace("aws:ec2:vpc")
 *                     .name("VPCId")
 *                     .value("vpc-xxxxxxxx")
 *                     .build(),
 *                 EnvironmentSettingArgs.builder()
 *                     .namespace("aws:ec2:vpc")
 *                     .name("Subnets")
 *                     .value("subnet-xxxxxxxx")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   tftest:
 *     type: aws:elasticbeanstalk:Application
 *     properties:
 *       name: tf-test-name
 *       description: tf-test-desc
 *   tfenvtest:
 *     type: aws:elasticbeanstalk:Environment
 *     properties:
 *       name: tf-test-name
 *       application: ${tftest.name}
 *       solutionStackName: 64bit Amazon Linux 2015.03 v2.0.3 running Go 1.4
 *       settings:
 *         - namespace: aws:ec2:vpc
 *           name: VPCId
 *           value: vpc-xxxxxxxx
 *         - namespace: aws:ec2:vpc
 *           name: Subnets
 *           value: subnet-xxxxxxxx
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Elastic Beanstalk Environments using the `id`. For example:
 * ```sh
 * $ pulumi import aws:elasticbeanstalk/environment:Environment prodenv e-rpqsewtp2j
 * ```
 */
public class Environment internal constructor(
    override val javaResource: com.pulumi.aws.elasticbeanstalk.Environment,
) : KotlinCustomResource(javaResource, EnvironmentMapper) {
    /**
     * List of all option settings configured in this Environment. These
     * are a combination of default settings and their overrides from `setting` in
     * the configuration.
     */
    public val allSettings: Output<List<EnvironmentAllSetting>>
        get() = javaResource.allSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    environmentAllSettingToKotlin(args0)
                })
            })
        })

    /**
     * Name of the application that contains the version
     * to be deployed
     */
    public val application: Output<String>
        get() = javaResource.application().applyValue({ args0 -> args0 })

    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The autoscaling groups used by this Environment.
     */
    public val autoscalingGroups: Output<List<String>>
        get() = javaResource.autoscalingGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Fully qualified DNS name for this Environment.
     */
    public val cname: Output<String>
        get() = javaResource.cname().applyValue({ args0 -> args0 })

    /**
     * Prefix to use for the fully qualified DNS name of
     * the Environment.
     */
    public val cnamePrefix: Output<String>
        get() = javaResource.cnamePrefix().applyValue({ args0 -> args0 })

    /**
     * Short description of the Environment
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The URL to the Load Balancer for this Environment
     */
    public val endpointUrl: Output<String>
        get() = javaResource.endpointUrl().applyValue({ args0 -> args0 })

    /**
     * Instances used by this Environment.
     */
    public val instances: Output<List<String>>
        get() = javaResource.instances().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Launch configurations in use by this Environment.
     */
    public val launchConfigurations: Output<List<String>>
        get() = javaResource.launchConfigurations().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Elastic load balancers in use by this Environment.
     */
    public val loadBalancers: Output<List<String>>
        get() = javaResource.loadBalancers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A unique name for this Environment. This name is used
     * in the application URL
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The [ARN](https://docs&#46;aws&#46;amazon&#46;com/general/latest/gr/aws-arns-and-namespaces&#46;html) of the Elastic Beanstalk [Platform](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-beanstalk-environment.html#cfn-beanstalk-environment-platformarn)
     * to use in deployment
     */
    public val platformArn: Output<String>
        get() = javaResource.platformArn().applyValue({ args0 -> args0 })

    /**
     * The time between polling the AWS API to
     * check if changes have been applied. Use this to adjust the rate of API calls
     * for any `create` or `update` action. Minimum `10s`, maximum `180s`. Omit this to
     * use the default behavior, which is an exponential backoff
     */
    public val pollInterval: Output<String>?
        get() = javaResource.pollInterval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SQS queues in use by this Environment.
     */
    public val queues: Output<List<String>>
        get() = javaResource.queues().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Option settings to configure the new Environment. These
     * override specific values that are set as defaults. The format is detailed
     * below in Option Settings
     */
    public val settings: Output<List<EnvironmentSetting>>?
        get() = javaResource.settings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> environmentSettingToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A solution stack to base your environment
     * off of. Example stacks can be found in the [Amazon API documentation](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
     */
    public val solutionStackName: Output<String>
        get() = javaResource.solutionStackName().applyValue({ args0 -> args0 })

    /**
     * A set of tags to apply to the Environment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The name of the Elastic Beanstalk Configuration
     * template to use in deployment
     */
    public val templateName: Output<String>?
        get() = javaResource.templateName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Elastic Beanstalk Environment tier. Valid values are `Worker`
     * or `WebServer`. If tier is left blank `WebServer` will be used.
     */
    public val tier: Output<String>?
        get() = javaResource.tier().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Autoscaling triggers in use by this Environment.
     */
    public val triggers: Output<List<String>>
        get() = javaResource.triggers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the Elastic Beanstalk Application Version
     * to use in deployment.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })

    /**
     * The maximum
     * [duration](https://golang.org/pkg/time/#ParseDuration) that this provider should
     * wait for an Elastic Beanstalk Environment to be in a ready state before timing
     * out.
     */
    public val waitForReadyTimeout: Output<String>?
        get() = javaResource.waitForReadyTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object EnvironmentMapper : ResourceMapper<Environment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.elasticbeanstalk.Environment::class == javaResource::class

    override fun map(javaResource: Resource): Environment = Environment(
        javaResource as
            com.pulumi.aws.elasticbeanstalk.Environment,
    )
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Environment].
 */
public suspend fun environment(name: String, block: suspend EnvironmentResourceBuilder.() -> Unit): Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Environment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun environment(name: String): Environment {
    val builder = EnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
