@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin.inputs

import com.pulumi.aws.elasticbeanstalk.inputs.EnvironmentSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name A unique name for this Environment. This name is used
 * in the application URL
 * @property namespace
 * @property resource
 * @property value
 */
public data class EnvironmentSettingArgs(
    public val name: Output<String>,
    public val namespace: Output<String>,
    public val resource: Output<String>? = null,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.elasticbeanstalk.inputs.EnvironmentSettingArgs> {
    override fun toJava(): com.pulumi.aws.elasticbeanstalk.inputs.EnvironmentSettingArgs =
        com.pulumi.aws.elasticbeanstalk.inputs.EnvironmentSettingArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .namespace(namespace.applyValue({ args0 -> args0 }))
            .resource(resource?.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnvironmentSettingArgs].
 */
@PulumiTagMarker
public class EnvironmentSettingArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var namespace: Output<String>? = null

    private var resource: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value A unique name for this Environment. This name is used
     * in the application URL
     */
    @JvmName("fdugwghpawpqkhql")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("utjlqgovcldfyybd")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value
     */
    @JvmName("arxwsdhoicsaaioy")
    public suspend fun resource(`value`: Output<String>) {
        this.resource = value
    }

    /**
     * @param value
     */
    @JvmName("tkfqtmjncmnccfgd")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value A unique name for this Environment. This name is used
     * in the application URL
     */
    @JvmName("waxwcejcgvqwxwcc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("jvbietabfltesani")
    public suspend fun namespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value
     */
    @JvmName("aekgslfayuyxqyeh")
    public suspend fun resource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    /**
     * @param value
     */
    @JvmName("knoqxaxmhapcdxou")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EnvironmentSettingArgs = EnvironmentSettingArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        namespace = namespace ?: throw PulumiNullFieldException("namespace"),
        resource = resource,
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
