@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin.inputs

import com.pulumi.aws.elasticbeanstalk.inputs.GetHostedZonePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHostedZone.
 * @property region Region you'd like the zone for. By default, fetches the current region.
 */
public data class GetHostedZonePlainArgs(
    public val region: String? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticbeanstalk.inputs.GetHostedZonePlainArgs> {
    override fun toJava(): com.pulumi.aws.elasticbeanstalk.inputs.GetHostedZonePlainArgs =
        com.pulumi.aws.elasticbeanstalk.inputs.GetHostedZonePlainArgs.builder()
            .region(region?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHostedZonePlainArgs].
 */
@PulumiTagMarker
public class GetHostedZonePlainArgsBuilder internal constructor() {
    private var region: String? = null

    /**
     * @param value Region you'd like the zone for. By default, fetches the current region.
     */
    @JvmName("uawwxtyapwmklclr")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.region = mapped
    }

    internal fun build(): GetHostedZonePlainArgs = GetHostedZonePlainArgs(
        region = region,
    )
}
