@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name A unique name for this Environment. This name is used
 * in the application URL
 * @property namespace
 * @property resource
 * @property value
 */
public data class EnvironmentAllSetting(
    public val name: String,
    public val namespace: String,
    public val resource: String? = null,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticbeanstalk.outputs.EnvironmentAllSetting): EnvironmentAllSetting = EnvironmentAllSetting(
            name = javaType.name(),
            namespace = javaType.namespace(),
            resource = javaType.resource().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`(),
        )
    }
}
