@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getApplication.
 * @property appversionLifecycle
 * @property arn ARN of the application.
 * @property description Short description of the application
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 */
public data class GetApplicationResult(
    public val appversionLifecycle: GetApplicationAppversionLifecycle,
    public val arn: String,
    public val description: String,
    public val id: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticbeanstalk.outputs.GetApplicationResult): GetApplicationResult = GetApplicationResult(
            appversionLifecycle = javaType.appversionLifecycle().let({ args0 ->
                com.pulumi.aws.elasticbeanstalk.kotlin.outputs.GetApplicationAppversionLifecycle.Companion.toKotlin(args0)
            }),
            arn = javaType.arn(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
        )
    }
}
