@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticbeanstalk.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getHostedZone.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property region Region of the hosted zone.
 */
public data class GetHostedZoneResult(
    public val id: String,
    public val region: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticbeanstalk.outputs.GetHostedZoneResult): GetHostedZoneResult = GetHostedZoneResult(
            id = javaType.id(),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
        )
    }
}
