@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin

import com.pulumi.aws.elasticsearch.DomainPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Allows setting policy to an Elasticsearch domain while referencing domain attributes (e.g., ARN)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.elasticsearch.Domain("example", {
 *     domainName: "tf-test",
 *     elasticsearchVersion: "2.3",
 * });
 * const main = new aws.elasticsearch.DomainPolicy("main", {
 *     domainName: example.domainName,
 *     accessPolicies: pulumi.interpolate`{
 *     "Version": "2012-10-17",
 *     "Statement": [
 *         {
 *             "Action": "es:*",
 *             "Principal": "*",
 *             "Effect": "Allow",
 *             "Condition": {
 *                 "IpAddress": {"aws:SourceIp": "127.0.0.1/32"}
 *             },
 *             "Resource": "${example.arn}/*"
 *         }
 *     ]
 * }
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.elasticsearch.Domain("example",
 *     domain_name="tf-test",
 *     elasticsearch_version="2.3")
 * main = aws.elasticsearch.DomainPolicy("main",
 *     domain_name=example.domain_name,
 *     access_policies=example.arn.apply(lambda arn: f"""{{
 *     "Version": "2012-10-17",
 *     "Statement": [
 *         {{
 *             "Action": "es:*",
 *             "Principal": "*",
 *             "Effect": "Allow",
 *             "Condition": {{
 *                 "IpAddress": {{"aws:SourceIp": "127.0.0.1/32"}}
 *             }},
 *             "Resource": "{arn}/*"
 *         }}
 *     ]
 * }}
 * """))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ElasticSearch.Domain("example", new()
 *     {
 *         DomainName = "tf-test",
 *         ElasticsearchVersion = "2.3",
 *     });
 *     var main = new Aws.ElasticSearch.DomainPolicy("main", new()
 *     {
 *         DomainName = example.DomainName,
 *         AccessPolicies = example.Arn.Apply(arn => @$"{{
 *     ""Version"": ""2012-10-17"",
 *     ""Statement"": [
 *         {{
 *             ""Action"": ""es:*"",
 *             ""Principal"": ""*"",
 *             ""Effect"": ""Allow"",
 *             ""Condition"": {{
 *                 ""IpAddress"": {{""aws:SourceIp"": ""127.0.0.1/32""}}
 *             }},
 *             ""Resource"": ""{arn}/*""
 *         }}
 *     ]
 * }}
 * "),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/elasticsearch"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := elasticsearch.NewDomain(ctx, "example", &elasticsearch.DomainArgs{
 * 			DomainName:           pulumi.String("tf-test"),
 * 			ElasticsearchVersion: pulumi.String("2.3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = elasticsearch.NewDomainPolicy(ctx, "main", &elasticsearch.DomainPolicyArgs{
 * 			DomainName: example.DomainName,
 * 			AccessPolicies: example.Arn.ApplyT(func(arn string) (string, error) {
 * 				return fmt.Sprintf(`{
 *     "Version": "2012-10-17",
 *     "Statement": [
 *         {
 *             "Action": "es:*",
 *             "Principal": "*",
 *             "Effect": "Allow",
 *             "Condition": {
 *                 "IpAddress": {"aws:SourceIp": "127.0.0.1/32"}
 *             },
 *             "Resource": "%v/*"
 *         }
 *     ]
 * }
 * `, arn), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.elasticsearch.Domain;
 * import com.pulumi.aws.elasticsearch.DomainArgs;
 * import com.pulumi.aws.elasticsearch.DomainPolicy;
 * import com.pulumi.aws.elasticsearch.DomainPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Domain("example", DomainArgs.builder()
 *             .domainName("tf-test")
 *             .elasticsearchVersion("2.3")
 *             .build());
 *         var main = new DomainPolicy("main", DomainPolicyArgs.builder()
 *             .domainName(example.domainName())
 *             .accessPolicies(example.arn().applyValue(arn -> """
 * {
 *     "Version": "2012-10-17",
 *     "Statement": [
 *         {
 *             "Action": "es:*",
 *             "Principal": "*",
 *             "Effect": "Allow",
 *             "Condition": {
 *                 "IpAddress": {"aws:SourceIp": "127.0.0.1/32"}
 *             },
 *             "Resource": "%s/*"
 *         }
 *     ]
 * }
 * ", arn)))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:elasticsearch:Domain
 *     properties:
 *       domainName: tf-test
 *       elasticsearchVersion: '2.3'
 *   main:
 *     type: aws:elasticsearch:DomainPolicy
 *     properties:
 *       domainName: ${example.domainName}
 *       accessPolicies: |
 *         {
 *             "Version": "2012-10-17",
 *             "Statement": [
 *                 {
 *                     "Action": "es:*",
 *                     "Principal": "*",
 *                     "Effect": "Allow",
 *                     "Condition": {
 *                         "IpAddress": {"aws:SourceIp": "127.0.0.1/32"}
 *                     },
 *                     "Resource": "${example.arn}/*"
 *                 }
 *             ]
 *         }
 * ```
 * <!--End PulumiCodeChooser -->
 * @property accessPolicies IAM policy document specifying the access policies for the domain
 * @property domainName Name of the domain.
 * */*/*/*/*/*/
 */
public data class DomainPolicyArgs(
    public val accessPolicies: Output<String>? = null,
    public val domainName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticsearch.DomainPolicyArgs> {
    override fun toJava(): com.pulumi.aws.elasticsearch.DomainPolicyArgs =
        com.pulumi.aws.elasticsearch.DomainPolicyArgs.builder()
            .accessPolicies(accessPolicies?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainPolicyArgs].
 */
@PulumiTagMarker
public class DomainPolicyArgsBuilder internal constructor() {
    private var accessPolicies: Output<String>? = null

    private var domainName: Output<String>? = null

    /**
     * @param value IAM policy document specifying the access policies for the domain
     */
    @JvmName("ifbpbljfomykalkr")
    public suspend fun accessPolicies(`value`: Output<String>) {
        this.accessPolicies = value
    }

    /**
     * @param value Name of the domain.
     */
    @JvmName("huprmuebfedyoqek")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value IAM policy document specifying the access policies for the domain
     */
    @JvmName("nyncybgjtgcldguj")
    public suspend fun accessPolicies(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessPolicies = mapped
    }

    /**
     * @param value Name of the domain.
     */
    @JvmName("uoavsfnwvjpwbqbf")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    internal fun build(): DomainPolicyArgs = DomainPolicyArgs(
        accessPolicies = accessPolicies,
        domainName = domainName,
    )
}
