@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.inputs

import com.pulumi.aws.elasticsearch.inputs.DomainAdvancedSecurityOptionsMasterUserOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property masterUserArn ARN for the main user. Only specify if `internal_user_database_enabled` is not set or set to `false`.
 * @property masterUserName Main user's username, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
 * @property masterUserPassword Main user's password, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
 */
public data class DomainAdvancedSecurityOptionsMasterUserOptionsArgs(
    public val masterUserArn: Output<String>? = null,
    public val masterUserName: Output<String>? = null,
    public val masterUserPassword: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.elasticsearch.inputs.DomainAdvancedSecurityOptionsMasterUserOptionsArgs> {
    override fun toJava(): com.pulumi.aws.elasticsearch.inputs.DomainAdvancedSecurityOptionsMasterUserOptionsArgs =
        com.pulumi.aws.elasticsearch.inputs.DomainAdvancedSecurityOptionsMasterUserOptionsArgs.builder()
            .masterUserArn(masterUserArn?.applyValue({ args0 -> args0 }))
            .masterUserName(masterUserName?.applyValue({ args0 -> args0 }))
            .masterUserPassword(masterUserPassword?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainAdvancedSecurityOptionsMasterUserOptionsArgs].
 */
@PulumiTagMarker
public class DomainAdvancedSecurityOptionsMasterUserOptionsArgsBuilder internal constructor() {
    private var masterUserArn: Output<String>? = null

    private var masterUserName: Output<String>? = null

    private var masterUserPassword: Output<String>? = null

    /**
     * @param value ARN for the main user. Only specify if `internal_user_database_enabled` is not set or set to `false`.
     */
    @JvmName("rkwrqkbyrksqrpxq")
    public suspend fun masterUserArn(`value`: Output<String>) {
        this.masterUserArn = value
    }

    /**
     * @param value Main user's username, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
     */
    @JvmName("sfliotsnqwppeygs")
    public suspend fun masterUserName(`value`: Output<String>) {
        this.masterUserName = value
    }

    /**
     * @param value Main user's password, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
     */
    @JvmName("dlocwcnfrwoploqn")
    public suspend fun masterUserPassword(`value`: Output<String>) {
        this.masterUserPassword = value
    }

    /**
     * @param value ARN for the main user. Only specify if `internal_user_database_enabled` is not set or set to `false`.
     */
    @JvmName("gcxeoycbjwawuheb")
    public suspend fun masterUserArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterUserArn = mapped
    }

    /**
     * @param value Main user's username, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
     */
    @JvmName("gaxavbbugmrfdlak")
    public suspend fun masterUserName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterUserName = mapped
    }

    /**
     * @param value Main user's password, which is stored in the Amazon Elasticsearch Service domain's internal database. Only specify if `internal_user_database_enabled` is set to `true`.
     */
    @JvmName("eaoakctcvqtxmcma")
    public suspend fun masterUserPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterUserPassword = mapped
    }

    internal fun build(): DomainAdvancedSecurityOptionsMasterUserOptionsArgs =
        DomainAdvancedSecurityOptionsMasterUserOptionsArgs(
            masterUserArn = masterUserArn,
            masterUserName = masterUserName,
            masterUserPassword = masterUserPassword,
        )
}
