@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.inputs

import com.pulumi.aws.elasticsearch.inputs.DomainAutoTuneOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property desiredState The Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
 * @property maintenanceSchedules Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
 * @property rollbackOnDisable Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
 */
public data class DomainAutoTuneOptionsArgs(
    public val desiredState: Output<String>,
    public val maintenanceSchedules: Output<List<DomainAutoTuneOptionsMaintenanceScheduleArgs>>? =
        null,
    public val rollbackOnDisable: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticsearch.inputs.DomainAutoTuneOptionsArgs> {
    override fun toJava(): com.pulumi.aws.elasticsearch.inputs.DomainAutoTuneOptionsArgs =
        com.pulumi.aws.elasticsearch.inputs.DomainAutoTuneOptionsArgs.builder()
            .desiredState(desiredState.applyValue({ args0 -> args0 }))
            .maintenanceSchedules(
                maintenanceSchedules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .rollbackOnDisable(rollbackOnDisable?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainAutoTuneOptionsArgs].
 */
@PulumiTagMarker
public class DomainAutoTuneOptionsArgsBuilder internal constructor() {
    private var desiredState: Output<String>? = null

    private var maintenanceSchedules: Output<List<DomainAutoTuneOptionsMaintenanceScheduleArgs>>? =
        null

    private var rollbackOnDisable: Output<String>? = null

    /**
     * @param value The Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
     */
    @JvmName("cbwerrwxowcsqwtq")
    public suspend fun desiredState(`value`: Output<String>) {
        this.desiredState = value
    }

    /**
     * @param value Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
     */
    @JvmName("urretcpbhyitdsqk")
    public suspend fun maintenanceSchedules(`value`: Output<List<DomainAutoTuneOptionsMaintenanceScheduleArgs>>) {
        this.maintenanceSchedules = value
    }

    @JvmName("mchlxfnbptslivpl")
    public suspend fun maintenanceSchedules(vararg values: Output<DomainAutoTuneOptionsMaintenanceScheduleArgs>) {
        this.maintenanceSchedules = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
     */
    @JvmName("gpvgttefchdlbavk")
    public suspend fun maintenanceSchedules(values: List<Output<DomainAutoTuneOptionsMaintenanceScheduleArgs>>) {
        this.maintenanceSchedules = Output.all(values)
    }

    /**
     * @param value Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
     */
    @JvmName("opbivemoqhqrfhmj")
    public suspend fun rollbackOnDisable(`value`: Output<String>) {
        this.rollbackOnDisable = value
    }

    /**
     * @param value The Auto-Tune desired state for the domain. Valid values: `ENABLED` or `DISABLED`.
     */
    @JvmName("sfcobwsjnrgfgvka")
    public suspend fun desiredState(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.desiredState = mapped
    }

    /**
     * @param value Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
     */
    @JvmName("tejdpbpwrgfhupou")
    public suspend fun maintenanceSchedules(`value`: List<DomainAutoTuneOptionsMaintenanceScheduleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceSchedules = mapped
    }

    /**
     * @param argument Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
     */
    @JvmName("mubpxxapykgymmvv")
    public suspend fun maintenanceSchedules(argument: List<suspend DomainAutoTuneOptionsMaintenanceScheduleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainAutoTuneOptionsMaintenanceScheduleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.maintenanceSchedules = mapped
    }

    /**
     * @param argument Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
     */
    @JvmName("rnbytdjecrmcnicq")
    public suspend fun maintenanceSchedules(vararg argument: suspend DomainAutoTuneOptionsMaintenanceScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainAutoTuneOptionsMaintenanceScheduleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.maintenanceSchedules = mapped
    }

    /**
     * @param argument Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
     */
    @JvmName("dtldklmqwcwblurv")
    public suspend fun maintenanceSchedules(argument: suspend DomainAutoTuneOptionsMaintenanceScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DomainAutoTuneOptionsMaintenanceScheduleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.maintenanceSchedules = mapped
    }

    /**
     * @param values Configuration block for Auto-Tune maintenance windows. Can be specified multiple times for each maintenance window. Detailed below.
     */
    @JvmName("ncxxpncitdwglyuj")
    public suspend fun maintenanceSchedules(vararg values: DomainAutoTuneOptionsMaintenanceScheduleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maintenanceSchedules = mapped
    }

    /**
     * @param value Whether to roll back to default Auto-Tune settings when disabling Auto-Tune. Valid values: `DEFAULT_ROLLBACK` or `NO_ROLLBACK`.
     */
    @JvmName("sesidbpkjiygqpbb")
    public suspend fun rollbackOnDisable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rollbackOnDisable = mapped
    }

    internal fun build(): DomainAutoTuneOptionsArgs = DomainAutoTuneOptionsArgs(
        desiredState = desiredState ?: throw PulumiNullFieldException("desiredState"),
        maintenanceSchedules = maintenanceSchedules,
        rollbackOnDisable = rollbackOnDisable,
    )
}
