@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.inputs

import com.pulumi.aws.elasticsearch.inputs.DomainAutoTuneOptionsMaintenanceScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cronExpressionForRecurrence A cron expression specifying the recurrence pattern for an Auto-Tune maintenance schedule.
 * @property duration Configuration block for the duration of the Auto-Tune maintenance window. Detailed below.
 * @property startAt Date and time at which to start the Auto-Tune maintenance schedule in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
 */
public data class DomainAutoTuneOptionsMaintenanceScheduleArgs(
    public val cronExpressionForRecurrence: Output<String>,
    public val duration: Output<DomainAutoTuneOptionsMaintenanceScheduleDurationArgs>,
    public val startAt: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.elasticsearch.inputs.DomainAutoTuneOptionsMaintenanceScheduleArgs> {
    override fun toJava(): com.pulumi.aws.elasticsearch.inputs.DomainAutoTuneOptionsMaintenanceScheduleArgs =
        com.pulumi.aws.elasticsearch.inputs.DomainAutoTuneOptionsMaintenanceScheduleArgs.builder()
            .cronExpressionForRecurrence(cronExpressionForRecurrence.applyValue({ args0 -> args0 }))
            .duration(duration.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .startAt(startAt.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainAutoTuneOptionsMaintenanceScheduleArgs].
 */
@PulumiTagMarker
public class DomainAutoTuneOptionsMaintenanceScheduleArgsBuilder internal constructor() {
    private var cronExpressionForRecurrence: Output<String>? = null

    private var duration: Output<DomainAutoTuneOptionsMaintenanceScheduleDurationArgs>? = null

    private var startAt: Output<String>? = null

    /**
     * @param value A cron expression specifying the recurrence pattern for an Auto-Tune maintenance schedule.
     */
    @JvmName("tosutsjploukukxr")
    public suspend fun cronExpressionForRecurrence(`value`: Output<String>) {
        this.cronExpressionForRecurrence = value
    }

    /**
     * @param value Configuration block for the duration of the Auto-Tune maintenance window. Detailed below.
     */
    @JvmName("xnikmewpnnasuktu")
    public suspend fun duration(`value`: Output<DomainAutoTuneOptionsMaintenanceScheduleDurationArgs>) {
        this.duration = value
    }

    /**
     * @param value Date and time at which to start the Auto-Tune maintenance schedule in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("nltgpfquoydivbtm")
    public suspend fun startAt(`value`: Output<String>) {
        this.startAt = value
    }

    /**
     * @param value A cron expression specifying the recurrence pattern for an Auto-Tune maintenance schedule.
     */
    @JvmName("njferjpqoopxxrsq")
    public suspend fun cronExpressionForRecurrence(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cronExpressionForRecurrence = mapped
    }

    /**
     * @param value Configuration block for the duration of the Auto-Tune maintenance window. Detailed below.
     */
    @JvmName("bpkehiuurapibvcy")
    public suspend fun duration(`value`: DomainAutoTuneOptionsMaintenanceScheduleDurationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param argument Configuration block for the duration of the Auto-Tune maintenance window. Detailed below.
     */
    @JvmName("ornoeumjjnddyujp")
    public suspend fun duration(argument: suspend DomainAutoTuneOptionsMaintenanceScheduleDurationArgsBuilder.() -> Unit) {
        val toBeMapped = DomainAutoTuneOptionsMaintenanceScheduleDurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.duration = mapped
    }

    /**
     * @param value Date and time at which to start the Auto-Tune maintenance schedule in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8).
     */
    @JvmName("gbbimensehcktrhs")
    public suspend fun startAt(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startAt = mapped
    }

    internal fun build(): DomainAutoTuneOptionsMaintenanceScheduleArgs =
        DomainAutoTuneOptionsMaintenanceScheduleArgs(
            cronExpressionForRecurrence = cronExpressionForRecurrence ?: throw
                PulumiNullFieldException("cronExpressionForRecurrence"),
            duration = duration ?: throw PulumiNullFieldException("duration"),
            startAt = startAt ?: throw PulumiNullFieldException("startAt"),
        )
}
