@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.inputs

import com.pulumi.aws.elasticsearch.inputs.DomainClusterConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property coldStorageOptions Configuration block containing cold storage configuration. Detailed below.
 * @property dedicatedMasterCount Number of dedicated main nodes in the cluster.
 * @property dedicatedMasterEnabled Whether dedicated main nodes are enabled for the cluster.
 * @property dedicatedMasterType Instance type of the dedicated main nodes in the cluster.
 * @property instanceCount Number of instances in the cluster.
 * @property instanceType Instance type of data nodes in the cluster.
 * @property warmCount Number of warm nodes in the cluster. Valid values are between `2` and `150`. `warm_count` can be only and must be set when `warm_enabled` is set to `true`.
 * @property warmEnabled Whether to enable warm storage.
 * @property warmType Instance type for the Elasticsearch cluster's warm nodes. Valid values are `ultrawarm1.medium.elasticsearch`, `ultrawarm1.large.elasticsearch` and `ultrawarm1.xlarge.elasticsearch`. `warm_type` can be only and must be set when `warm_enabled` is set to `true`.
 * @property zoneAwarenessConfig Configuration block containing zone awareness settings. Detailed below.
 * @property zoneAwarenessEnabled Whether zone awareness is enabled, set to `true` for multi-az deployment. To enable awareness with three Availability Zones, the `availability_zone_count` within the `zone_awareness_config` must be set to `3`.
 */
public data class DomainClusterConfigArgs(
    public val coldStorageOptions: Output<DomainClusterConfigColdStorageOptionsArgs>? = null,
    public val dedicatedMasterCount: Output<Int>? = null,
    public val dedicatedMasterEnabled: Output<Boolean>? = null,
    public val dedicatedMasterType: Output<String>? = null,
    public val instanceCount: Output<Int>? = null,
    public val instanceType: Output<String>? = null,
    public val warmCount: Output<Int>? = null,
    public val warmEnabled: Output<Boolean>? = null,
    public val warmType: Output<String>? = null,
    public val zoneAwarenessConfig: Output<DomainClusterConfigZoneAwarenessConfigArgs>? = null,
    public val zoneAwarenessEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticsearch.inputs.DomainClusterConfigArgs> {
    override fun toJava(): com.pulumi.aws.elasticsearch.inputs.DomainClusterConfigArgs =
        com.pulumi.aws.elasticsearch.inputs.DomainClusterConfigArgs.builder()
            .coldStorageOptions(
                coldStorageOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dedicatedMasterCount(dedicatedMasterCount?.applyValue({ args0 -> args0 }))
            .dedicatedMasterEnabled(dedicatedMasterEnabled?.applyValue({ args0 -> args0 }))
            .dedicatedMasterType(dedicatedMasterType?.applyValue({ args0 -> args0 }))
            .instanceCount(instanceCount?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .warmCount(warmCount?.applyValue({ args0 -> args0 }))
            .warmEnabled(warmEnabled?.applyValue({ args0 -> args0 }))
            .warmType(warmType?.applyValue({ args0 -> args0 }))
            .zoneAwarenessConfig(
                zoneAwarenessConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .zoneAwarenessEnabled(zoneAwarenessEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainClusterConfigArgs].
 */
@PulumiTagMarker
public class DomainClusterConfigArgsBuilder internal constructor() {
    private var coldStorageOptions: Output<DomainClusterConfigColdStorageOptionsArgs>? = null

    private var dedicatedMasterCount: Output<Int>? = null

    private var dedicatedMasterEnabled: Output<Boolean>? = null

    private var dedicatedMasterType: Output<String>? = null

    private var instanceCount: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var warmCount: Output<Int>? = null

    private var warmEnabled: Output<Boolean>? = null

    private var warmType: Output<String>? = null

    private var zoneAwarenessConfig: Output<DomainClusterConfigZoneAwarenessConfigArgs>? = null

    private var zoneAwarenessEnabled: Output<Boolean>? = null

    /**
     * @param value Configuration block containing cold storage configuration. Detailed below.
     */
    @JvmName("mgxksuvwkrkxfhbm")
    public suspend fun coldStorageOptions(`value`: Output<DomainClusterConfigColdStorageOptionsArgs>) {
        this.coldStorageOptions = value
    }

    /**
     * @param value Number of dedicated main nodes in the cluster.
     */
    @JvmName("utflnageukvctynl")
    public suspend fun dedicatedMasterCount(`value`: Output<Int>) {
        this.dedicatedMasterCount = value
    }

    /**
     * @param value Whether dedicated main nodes are enabled for the cluster.
     */
    @JvmName("ewgaqyjmrgvduofq")
    public suspend fun dedicatedMasterEnabled(`value`: Output<Boolean>) {
        this.dedicatedMasterEnabled = value
    }

    /**
     * @param value Instance type of the dedicated main nodes in the cluster.
     */
    @JvmName("alrogcvhalaorlim")
    public suspend fun dedicatedMasterType(`value`: Output<String>) {
        this.dedicatedMasterType = value
    }

    /**
     * @param value Number of instances in the cluster.
     */
    @JvmName("jruxknqudhddjvrv")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value Instance type of data nodes in the cluster.
     */
    @JvmName("grdmfcpgkyyafibx")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Number of warm nodes in the cluster. Valid values are between `2` and `150`. `warm_count` can be only and must be set when `warm_enabled` is set to `true`.
     */
    @JvmName("nmojcvswfdaafwnb")
    public suspend fun warmCount(`value`: Output<Int>) {
        this.warmCount = value
    }

    /**
     * @param value Whether to enable warm storage.
     */
    @JvmName("ucjbfbphrpacejty")
    public suspend fun warmEnabled(`value`: Output<Boolean>) {
        this.warmEnabled = value
    }

    /**
     * @param value Instance type for the Elasticsearch cluster's warm nodes. Valid values are `ultrawarm1.medium.elasticsearch`, `ultrawarm1.large.elasticsearch` and `ultrawarm1.xlarge.elasticsearch`. `warm_type` can be only and must be set when `warm_enabled` is set to `true`.
     */
    @JvmName("hooephqvsljbcnxh")
    public suspend fun warmType(`value`: Output<String>) {
        this.warmType = value
    }

    /**
     * @param value Configuration block containing zone awareness settings. Detailed below.
     */
    @JvmName("jighlebsgqqrrapb")
    public suspend fun zoneAwarenessConfig(`value`: Output<DomainClusterConfigZoneAwarenessConfigArgs>) {
        this.zoneAwarenessConfig = value
    }

    /**
     * @param value Whether zone awareness is enabled, set to `true` for multi-az deployment. To enable awareness with three Availability Zones, the `availability_zone_count` within the `zone_awareness_config` must be set to `3`.
     */
    @JvmName("tjsrjluqhjrjkbdi")
    public suspend fun zoneAwarenessEnabled(`value`: Output<Boolean>) {
        this.zoneAwarenessEnabled = value
    }

    /**
     * @param value Configuration block containing cold storage configuration. Detailed below.
     */
    @JvmName("uosyghjwhmivcgos")
    public suspend fun coldStorageOptions(`value`: DomainClusterConfigColdStorageOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coldStorageOptions = mapped
    }

    /**
     * @param argument Configuration block containing cold storage configuration. Detailed below.
     */
    @JvmName("icanxstgmnlylyim")
    public suspend fun coldStorageOptions(argument: suspend DomainClusterConfigColdStorageOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainClusterConfigColdStorageOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.coldStorageOptions = mapped
    }

    /**
     * @param value Number of dedicated main nodes in the cluster.
     */
    @JvmName("xxjgdomvjxrgshqs")
    public suspend fun dedicatedMasterCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedMasterCount = mapped
    }

    /**
     * @param value Whether dedicated main nodes are enabled for the cluster.
     */
    @JvmName("isxwbxjtcdrwinoc")
    public suspend fun dedicatedMasterEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedMasterEnabled = mapped
    }

    /**
     * @param value Instance type of the dedicated main nodes in the cluster.
     */
    @JvmName("wegvrbychqrxcqfl")
    public suspend fun dedicatedMasterType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedMasterType = mapped
    }

    /**
     * @param value Number of instances in the cluster.
     */
    @JvmName("yfjtwflxsnkpkvan")
    public suspend fun instanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value Instance type of data nodes in the cluster.
     */
    @JvmName("vpgcislxakwpshtv")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Number of warm nodes in the cluster. Valid values are between `2` and `150`. `warm_count` can be only and must be set when `warm_enabled` is set to `true`.
     */
    @JvmName("dltwgedldemhxcbk")
    public suspend fun warmCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmCount = mapped
    }

    /**
     * @param value Whether to enable warm storage.
     */
    @JvmName("nivpovxcvyqneexp")
    public suspend fun warmEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmEnabled = mapped
    }

    /**
     * @param value Instance type for the Elasticsearch cluster's warm nodes. Valid values are `ultrawarm1.medium.elasticsearch`, `ultrawarm1.large.elasticsearch` and `ultrawarm1.xlarge.elasticsearch`. `warm_type` can be only and must be set when `warm_enabled` is set to `true`.
     */
    @JvmName("aerltkssngoxhprd")
    public suspend fun warmType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warmType = mapped
    }

    /**
     * @param value Configuration block containing zone awareness settings. Detailed below.
     */
    @JvmName("qavefbeekpppfnpt")
    public suspend fun zoneAwarenessConfig(`value`: DomainClusterConfigZoneAwarenessConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneAwarenessConfig = mapped
    }

    /**
     * @param argument Configuration block containing zone awareness settings. Detailed below.
     */
    @JvmName("ymwrjigwtrujqtdx")
    public suspend fun zoneAwarenessConfig(argument: suspend DomainClusterConfigZoneAwarenessConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DomainClusterConfigZoneAwarenessConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.zoneAwarenessConfig = mapped
    }

    /**
     * @param value Whether zone awareness is enabled, set to `true` for multi-az deployment. To enable awareness with three Availability Zones, the `availability_zone_count` within the `zone_awareness_config` must be set to `3`.
     */
    @JvmName("towqkkarwhlseovf")
    public suspend fun zoneAwarenessEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneAwarenessEnabled = mapped
    }

    internal fun build(): DomainClusterConfigArgs = DomainClusterConfigArgs(
        coldStorageOptions = coldStorageOptions,
        dedicatedMasterCount = dedicatedMasterCount,
        dedicatedMasterEnabled = dedicatedMasterEnabled,
        dedicatedMasterType = dedicatedMasterType,
        instanceCount = instanceCount,
        instanceType = instanceType,
        warmCount = warmCount,
        warmEnabled = warmEnabled,
        warmType = warmType,
        zoneAwarenessConfig = zoneAwarenessConfig,
        zoneAwarenessEnabled = zoneAwarenessEnabled,
    )
}
