@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.inputs

import com.pulumi.aws.elasticsearch.inputs.DomainClusterConfigColdStorageOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Boolean to enable cold storage for an Elasticsearch domain. Defaults to `false`. Master and ultrawarm nodes must be enabled for cold storage.
 */
public data class DomainClusterConfigColdStorageOptionsArgs(
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticsearch.inputs.DomainClusterConfigColdStorageOptionsArgs> {
    override fun toJava(): com.pulumi.aws.elasticsearch.inputs.DomainClusterConfigColdStorageOptionsArgs =
        com.pulumi.aws.elasticsearch.inputs.DomainClusterConfigColdStorageOptionsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainClusterConfigColdStorageOptionsArgs].
 */
@PulumiTagMarker
public class DomainClusterConfigColdStorageOptionsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Boolean to enable cold storage for an Elasticsearch domain. Defaults to `false`. Master and ultrawarm nodes must be enabled for cold storage.
     */
    @JvmName("idrmusftxlyxrhfr")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Boolean to enable cold storage for an Elasticsearch domain. Defaults to `false`. Master and ultrawarm nodes must be enabled for cold storage.
     */
    @JvmName("jlhcyhgrvdawoycc")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DomainClusterConfigColdStorageOptionsArgs =
        DomainClusterConfigColdStorageOptionsArgs(
            enabled = enabled,
        )
}
