@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.inputs

import com.pulumi.aws.elasticsearch.inputs.DomainCognitoOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether Amazon Cognito authentication with Kibana is enabled or not.
 * @property identityPoolId ID of the Cognito Identity Pool to use.
 * @property roleArn ARN of the IAM role that has the AmazonESCognitoAccess policy attached.
 * @property userPoolId ID of the Cognito User Pool to use.
 */
public data class DomainCognitoOptionsArgs(
    public val enabled: Output<Boolean>? = null,
    public val identityPoolId: Output<String>,
    public val roleArn: Output<String>,
    public val userPoolId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.elasticsearch.inputs.DomainCognitoOptionsArgs> {
    override fun toJava(): com.pulumi.aws.elasticsearch.inputs.DomainCognitoOptionsArgs =
        com.pulumi.aws.elasticsearch.inputs.DomainCognitoOptionsArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .identityPoolId(identityPoolId.applyValue({ args0 -> args0 }))
            .roleArn(roleArn.applyValue({ args0 -> args0 }))
            .userPoolId(userPoolId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainCognitoOptionsArgs].
 */
@PulumiTagMarker
public class DomainCognitoOptionsArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var identityPoolId: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var userPoolId: Output<String>? = null

    /**
     * @param value Whether Amazon Cognito authentication with Kibana is enabled or not.
     */
    @JvmName("airvvnlubaeknuhm")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value ID of the Cognito Identity Pool to use.
     */
    @JvmName("hlrlvyffhsgtyaba")
    public suspend fun identityPoolId(`value`: Output<String>) {
        this.identityPoolId = value
    }

    /**
     * @param value ARN of the IAM role that has the AmazonESCognitoAccess policy attached.
     */
    @JvmName("jjtqqacndrafsleb")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value ID of the Cognito User Pool to use.
     */
    @JvmName("mnrlwacupbmawniy")
    public suspend fun userPoolId(`value`: Output<String>) {
        this.userPoolId = value
    }

    /**
     * @param value Whether Amazon Cognito authentication with Kibana is enabled or not.
     */
    @JvmName("tctdpoffsiqlrtyk")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value ID of the Cognito Identity Pool to use.
     */
    @JvmName("rsjnelyulasyrpxe")
    public suspend fun identityPoolId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityPoolId = mapped
    }

    /**
     * @param value ARN of the IAM role that has the AmazonESCognitoAccess policy attached.
     */
    @JvmName("uengiemmuvsrcgle")
    public suspend fun roleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value ID of the Cognito User Pool to use.
     */
    @JvmName("yedpxtudoecwcpjm")
    public suspend fun userPoolId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userPoolId = mapped
    }

    internal fun build(): DomainCognitoOptionsArgs = DomainCognitoOptionsArgs(
        enabled = enabled,
        identityPoolId = identityPoolId ?: throw PulumiNullFieldException("identityPoolId"),
        roleArn = roleArn ?: throw PulumiNullFieldException("roleArn"),
        userPoolId = userPoolId ?: throw PulumiNullFieldException("userPoolId"),
    )
}
