@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.inputs

import com.pulumi.aws.elasticsearch.inputs.DomainDomainEndpointOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property customEndpoint Fully qualified domain for your custom endpoint.
 * @property customEndpointCertificateArn ACM certificate ARN for your custom endpoint.
 * @property customEndpointEnabled Whether to enable custom endpoint for the Elasticsearch domain.
 * @property enforceHttps Whether or not to require HTTPS. Defaults to `true`.
 * @property tlsSecurityPolicy Name of the TLS security policy that needs to be applied to the HTTPS endpoint. Valid values:  `Policy-Min-TLS-1-0-2019-07` and `Policy-Min-TLS-1-2-2019-07`. The provider will only perform drift detection if a configuration value is provided.
 */
public data class DomainDomainEndpointOptionsArgs(
    public val customEndpoint: Output<String>? = null,
    public val customEndpointCertificateArn: Output<String>? = null,
    public val customEndpointEnabled: Output<Boolean>? = null,
    public val enforceHttps: Output<Boolean>? = null,
    public val tlsSecurityPolicy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticsearch.inputs.DomainDomainEndpointOptionsArgs> {
    override fun toJava(): com.pulumi.aws.elasticsearch.inputs.DomainDomainEndpointOptionsArgs =
        com.pulumi.aws.elasticsearch.inputs.DomainDomainEndpointOptionsArgs.builder()
            .customEndpoint(customEndpoint?.applyValue({ args0 -> args0 }))
            .customEndpointCertificateArn(customEndpointCertificateArn?.applyValue({ args0 -> args0 }))
            .customEndpointEnabled(customEndpointEnabled?.applyValue({ args0 -> args0 }))
            .enforceHttps(enforceHttps?.applyValue({ args0 -> args0 }))
            .tlsSecurityPolicy(tlsSecurityPolicy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainDomainEndpointOptionsArgs].
 */
@PulumiTagMarker
public class DomainDomainEndpointOptionsArgsBuilder internal constructor() {
    private var customEndpoint: Output<String>? = null

    private var customEndpointCertificateArn: Output<String>? = null

    private var customEndpointEnabled: Output<Boolean>? = null

    private var enforceHttps: Output<Boolean>? = null

    private var tlsSecurityPolicy: Output<String>? = null

    /**
     * @param value Fully qualified domain for your custom endpoint.
     */
    @JvmName("dgwyxnqhskvxjhng")
    public suspend fun customEndpoint(`value`: Output<String>) {
        this.customEndpoint = value
    }

    /**
     * @param value ACM certificate ARN for your custom endpoint.
     */
    @JvmName("hkbedxcjwbqolhol")
    public suspend fun customEndpointCertificateArn(`value`: Output<String>) {
        this.customEndpointCertificateArn = value
    }

    /**
     * @param value Whether to enable custom endpoint for the Elasticsearch domain.
     */
    @JvmName("blgrihgvhgpuslny")
    public suspend fun customEndpointEnabled(`value`: Output<Boolean>) {
        this.customEndpointEnabled = value
    }

    /**
     * @param value Whether or not to require HTTPS. Defaults to `true`.
     */
    @JvmName("aputicwpreavufae")
    public suspend fun enforceHttps(`value`: Output<Boolean>) {
        this.enforceHttps = value
    }

    /**
     * @param value Name of the TLS security policy that needs to be applied to the HTTPS endpoint. Valid values:  `Policy-Min-TLS-1-0-2019-07` and `Policy-Min-TLS-1-2-2019-07`. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("jaroysipmfcsvrfh")
    public suspend fun tlsSecurityPolicy(`value`: Output<String>) {
        this.tlsSecurityPolicy = value
    }

    /**
     * @param value Fully qualified domain for your custom endpoint.
     */
    @JvmName("ityvurfheaidfjqc")
    public suspend fun customEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customEndpoint = mapped
    }

    /**
     * @param value ACM certificate ARN for your custom endpoint.
     */
    @JvmName("gcyccioxjacmnswt")
    public suspend fun customEndpointCertificateArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customEndpointCertificateArn = mapped
    }

    /**
     * @param value Whether to enable custom endpoint for the Elasticsearch domain.
     */
    @JvmName("qnxvohnpkknncjiq")
    public suspend fun customEndpointEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customEndpointEnabled = mapped
    }

    /**
     * @param value Whether or not to require HTTPS. Defaults to `true`.
     */
    @JvmName("xfffbodapdjfoyyg")
    public suspend fun enforceHttps(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforceHttps = mapped
    }

    /**
     * @param value Name of the TLS security policy that needs to be applied to the HTTPS endpoint. Valid values:  `Policy-Min-TLS-1-0-2019-07` and `Policy-Min-TLS-1-2-2019-07`. The provider will only perform drift detection if a configuration value is provided.
     */
    @JvmName("lcanjrxaftcwulwl")
    public suspend fun tlsSecurityPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsSecurityPolicy = mapped
    }

    internal fun build(): DomainDomainEndpointOptionsArgs = DomainDomainEndpointOptionsArgs(
        customEndpoint = customEndpoint,
        customEndpointCertificateArn = customEndpointCertificateArn,
        customEndpointEnabled = customEndpointEnabled,
        enforceHttps = enforceHttps,
        tlsSecurityPolicy = tlsSecurityPolicy,
    )
}
