@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.inputs

import com.pulumi.aws.elasticsearch.inputs.GetDomainPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDomain.
 * @property domainName Name of the domain.
 * @property tags Tags assigned to the domain.
 */
public data class GetDomainPlainArgs(
    public val domainName: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.elasticsearch.inputs.GetDomainPlainArgs> {
    override fun toJava(): com.pulumi.aws.elasticsearch.inputs.GetDomainPlainArgs =
        com.pulumi.aws.elasticsearch.inputs.GetDomainPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetDomainPlainArgs].
 */
@PulumiTagMarker
public class GetDomainPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the domain.
     */
    @JvmName("vfoolwdtdsjeajnn")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value Tags assigned to the domain.
     */
    @JvmName("rkbpqewwbtunvrbw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Tags assigned to the domain.
     */
    @JvmName("aypegmprrjgkiuoi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetDomainPlainArgs = GetDomainPlainArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        tags = tags,
    )
}
