@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property coldStorageOptions Configuration block containing cold storage configuration. Detailed below.
 * @property dedicatedMasterCount Number of dedicated main nodes in the cluster.
 * @property dedicatedMasterEnabled Whether dedicated main nodes are enabled for the cluster.
 * @property dedicatedMasterType Instance type of the dedicated main nodes in the cluster.
 * @property instanceCount Number of instances in the cluster.
 * @property instanceType Instance type of data nodes in the cluster.
 * @property warmCount Number of warm nodes in the cluster. Valid values are between `2` and `150`. `warm_count` can be only and must be set when `warm_enabled` is set to `true`.
 * @property warmEnabled Whether to enable warm storage.
 * @property warmType Instance type for the Elasticsearch cluster's warm nodes. Valid values are `ultrawarm1.medium.elasticsearch`, `ultrawarm1.large.elasticsearch` and `ultrawarm1.xlarge.elasticsearch`. `warm_type` can be only and must be set when `warm_enabled` is set to `true`.
 * @property zoneAwarenessConfig Configuration block containing zone awareness settings. Detailed below.
 * @property zoneAwarenessEnabled Whether zone awareness is enabled, set to `true` for multi-az deployment. To enable awareness with three Availability Zones, the `availability_zone_count` within the `zone_awareness_config` must be set to `3`.
 */
public data class DomainClusterConfig(
    public val coldStorageOptions: DomainClusterConfigColdStorageOptions? = null,
    public val dedicatedMasterCount: Int? = null,
    public val dedicatedMasterEnabled: Boolean? = null,
    public val dedicatedMasterType: String? = null,
    public val instanceCount: Int? = null,
    public val instanceType: String? = null,
    public val warmCount: Int? = null,
    public val warmEnabled: Boolean? = null,
    public val warmType: String? = null,
    public val zoneAwarenessConfig: DomainClusterConfigZoneAwarenessConfig? = null,
    public val zoneAwarenessEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticsearch.outputs.DomainClusterConfig): DomainClusterConfig = DomainClusterConfig(
            coldStorageOptions = javaType.coldStorageOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.elasticsearch.kotlin.outputs.DomainClusterConfigColdStorageOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dedicatedMasterCount = javaType.dedicatedMasterCount().map({ args0 -> args0 }).orElse(null),
            dedicatedMasterEnabled = javaType.dedicatedMasterEnabled().map({ args0 -> args0 }).orElse(null),
            dedicatedMasterType = javaType.dedicatedMasterType().map({ args0 -> args0 }).orElse(null),
            instanceCount = javaType.instanceCount().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType().map({ args0 -> args0 }).orElse(null),
            warmCount = javaType.warmCount().map({ args0 -> args0 }).orElse(null),
            warmEnabled = javaType.warmEnabled().map({ args0 -> args0 }).orElse(null),
            warmType = javaType.warmType().map({ args0 -> args0 }).orElse(null),
            zoneAwarenessConfig = javaType.zoneAwarenessConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.elasticsearch.kotlin.outputs.DomainClusterConfigZoneAwarenessConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            zoneAwarenessEnabled = javaType.zoneAwarenessEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
