@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Whether Amazon Cognito authentication with Kibana is enabled or not.
 * @property identityPoolId ID of the Cognito Identity Pool to use.
 * @property roleArn ARN of the IAM role that has the AmazonESCognitoAccess policy attached.
 * @property userPoolId ID of the Cognito User Pool to use.
 */
public data class DomainCognitoOptions(
    public val enabled: Boolean? = null,
    public val identityPoolId: String,
    public val roleArn: String,
    public val userPoolId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticsearch.outputs.DomainCognitoOptions): DomainCognitoOptions = DomainCognitoOptions(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            identityPoolId = javaType.identityPoolId(),
            roleArn = javaType.roleArn(),
            userPoolId = javaType.userPoolId(),
        )
    }
}
