@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Whether to enable encryption at rest. If the `encrypt_at_rest` block is not provided then this defaults to `false`. Enabling encryption on new domains requires `elasticsearch_version` 5.1 or greater.
 * @property kmsKeyId KMS key ARN to encrypt the Elasticsearch domain with. If not specified then it defaults to using the `aws/es` service KMS key. Note that KMS will accept a KMS key ID but will return the key ARN. To prevent the provider detecting unwanted changes, use the key ARN instead.
 */
public data class DomainEncryptAtRest(
    public val enabled: Boolean,
    public val kmsKeyId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticsearch.outputs.DomainEncryptAtRest): DomainEncryptAtRest = DomainEncryptAtRest(
            enabled = javaType.enabled(),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
