@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Whether SAML authentication is enabled.
 * @property idp Information from your identity provider.
 * @property masterBackendRole This backend role from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
 * @property masterUserName This username from the SAML IdP receives full permissions to the cluster, equivalent to a new master user.
 * @property rolesKey Element of the SAML assertion to use for backend roles. Default is roles.
 * @property sessionTimeoutMinutes Duration of a session in minutes after a user logs in. Default is 60. Maximum value is 1,440.
 * @property subjectKey Custom SAML attribute to use for user names. Default is an empty string - `""`. This will cause Elasticsearch to use the `NameID` element of the `Subject`, which is the default location for name identifiers in the SAML specification.
 */
public data class DomainSamlOptionsSamlOptions(
    public val enabled: Boolean? = null,
    public val idp: DomainSamlOptionsSamlOptionsIdp? = null,
    public val masterBackendRole: String? = null,
    public val masterUserName: String? = null,
    public val rolesKey: String? = null,
    public val sessionTimeoutMinutes: Int? = null,
    public val subjectKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticsearch.outputs.DomainSamlOptionsSamlOptions): DomainSamlOptionsSamlOptions = DomainSamlOptionsSamlOptions(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            idp = javaType.idp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.elasticsearch.kotlin.outputs.DomainSamlOptionsSamlOptionsIdp.Companion.toKotlin(args0)
                })
            }).orElse(null),
            masterBackendRole = javaType.masterBackendRole().map({ args0 -> args0 }).orElse(null),
            masterUserName = javaType.masterUserName().map({ args0 -> args0 }).orElse(null),
            rolesKey = javaType.rolesKey().map({ args0 -> args0 }).orElse(null),
            sessionTimeoutMinutes = javaType.sessionTimeoutMinutes().map({ args0 -> args0 }).orElse(null),
            subjectKey = javaType.subjectKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
