@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.elasticsearch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property entityId The unique Entity ID of the application in SAML Identity Provider.
 * @property metadataContent The Metadata of the SAML application in xml format.
 */
public data class DomainSamlOptionsSamlOptionsIdp(
    public val entityId: String,
    public val metadataContent: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.elasticsearch.outputs.DomainSamlOptionsSamlOptionsIdp): DomainSamlOptionsSamlOptionsIdp = DomainSamlOptionsSamlOptionsIdp(
            entityId = javaType.entityId(),
            metadataContent = javaType.metadataContent(),
        )
    }
}
